/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.service.registry.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.Service;
import org.tinygroup.service.registry.ServiceRegistry;
import org.tinygroup.service.registry.ServiceRegistryItem;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Map<String, ServiceRegistryItem> serviceIdMap = new HashMap<String, ServiceRegistryItem>();
    private final Map<Service, ServiceRegistryItem> serviceToServiceRegistryItem = new HashMap<Service, ServiceRegistryItem>();
    private boolean change = true;

    @Override
    public void registerService(ServiceRegistryItem serviceRegistryItem) {
        this.change = true;
        if (this.serviceIdMap.containsKey(serviceRegistryItem.getServiceId())) {
            LOGGER.logMessage(LogLevel.WARN, "\u670d\u52a1\u53f7:[{0}]\u5df2\u7ecf\u5b58\u5728,\u4e4b\u524d\u7684\u670d\u52a1\u5c06\u88ab\u8986\u76d6", new Object[]{serviceRegistryItem.getServiceId()});
            ServiceRegistryItem item = this.serviceIdMap.get(serviceRegistryItem.getServiceId());
            if (item != null) {
                this.serviceToServiceRegistryItem.remove(item.getService());
            }
        }
        LOGGER.logMessage(LogLevel.INFO, "\u6dfb\u52a0\u670d\u52a1[serviceId:{0}]", new Object[]{serviceRegistryItem.getServiceId()});
        this.serviceIdMap.put(serviceRegistryItem.getServiceId(), serviceRegistryItem);
        this.serviceToServiceRegistryItem.put(serviceRegistryItem.getService(), serviceRegistryItem);
    }

    @Override
    public void registerService(List<ServiceRegistryItem> serviceRegistryItems) {
        for (ServiceRegistryItem serviceRegistryItem : serviceRegistryItems) {
            this.registerService(serviceRegistryItem);
        }
    }

    @Override
    public void registerService(ServiceRegistryItem[] serviceRegistryItems) {
        for (ServiceRegistryItem serviceRegistryItem : serviceRegistryItems) {
            this.registerService(serviceRegistryItem);
        }
    }

    @Override
    public void registerService(Set<ServiceRegistryItem> serviceRegistryItems) {
        for (ServiceRegistryItem serviceRegistryItem : serviceRegistryItems) {
            this.registerService(serviceRegistryItem);
        }
    }

    @Override
    public void removeService(String serviceId) {
        this.removeService(this.serviceIdMap.get(serviceId));
    }

    private void removeService(ServiceRegistryItem serviceRegistryItem) {
        if (serviceRegistryItem == null) {
            return;
        }
        this.change = true;
        LOGGER.logMessage(LogLevel.INFO, "\u5220\u9664\u670d\u52a1[serviceId:{0}]", new Object[]{serviceRegistryItem.getServiceId()});
        ServiceRegistryItem removedItem = this.serviceIdMap.remove(serviceRegistryItem.getServiceId());
        this.serviceToServiceRegistryItem.remove(removedItem.getService());
    }

    @Override
    public int size() {
        return this.serviceToServiceRegistryItem.size();
    }

    @Override
    public void clear() {
        this.serviceIdMap.clear();
        this.serviceToServiceRegistryItem.clear();
    }

    @Override
    public ServiceRegistryItem getServiceRegistryItem(Service service) {
        return this.serviceToServiceRegistryItem.get(service);
    }

    @Override
    public ServiceRegistryItem getServiceRegistryItem(String serviceId) {
        return this.serviceIdMap.get(serviceId);
    }

    @Override
    public Collection<ServiceRegistryItem> getServiceRegistryItems() {
        return this.serviceIdMap.values();
    }

    @Override
    public boolean isChange() {
        return this.change;
    }

    @Override
    public void setChange(boolean change) {
        this.change = change;
    }
}

