/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicehttpchannelweb;

import java.io.IOException;
import javax.servlet.ServletException;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.context.Context;
import org.tinygroup.event.Event;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.servicehttpchannel.Hession;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class ServiceHttpServiceProcessor
extends AbstractTinyProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceHttpServiceProcessor.class);
    CEPCore core;

    protected void customInit() throws ServletException {
    }

    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        int lastSplash = urlString.lastIndexOf(47);
        int lastDot = urlString.lastIndexOf(46);
        String serviceId = urlString.substring(lastSplash + 1, lastDot);
        Event event = this.callService(serviceId, (Context)context);
        event.setType(2);
        if (urlString.endsWith("mockservice")) {
            context.getResponse().getOutputStream().write(Hession.serialize((Object)event));
        }
    }

    private Event callService(String serviceId, Context context) {
        Event event = null;
        try {
            event = (Event)Hession.deserialize((byte[])((byte[])context.get("TINY_MOCK_SERVICE")));
        }
        catch (IOException e1) {
            throw new RuntimeException("\u8bf7\u6c42:" + serviceId + "\u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u5931\u8d25", e1);
        }
        try {
            this.core.process(event);
        }
        catch (Exception e1) {
            LOGGER.errorMessage("\u8bf7\u6c42:{}\u6267\u884c\u5f02\u5e38", (Throwable)e1, new Object[]{serviceId});
            event.setThrowable((Throwable)e1);
        }
        return event;
    }

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }
}

