/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicewrapper;

import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.servicewrapper.InvokeNodeSetter;
import org.tinygroup.servicewrapper.ServiceIdAnaly;

public class ServiceWrapperInterceptor
implements MethodInterceptor {
    private CEPCore core;
    private ServiceIdAnaly serviceIdAnaly;
    private ParameterNameDiscoverer parameterNameDiscoverer;
    private String nodeName;

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public ServiceIdAnaly getServiceIdAnaly() {
        return this.serviceIdAnaly;
    }

    public void setServiceIdAnaly(ServiceIdAnaly serviceIdAnaly) {
        this.serviceIdAnaly = serviceIdAnaly;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        int argSize;
        Object[] args = invocation.getArguments();
        Method method = invocation.getMethod();
        Object target = invocation.getThis();
        if (AopUtils.isToStringMethod((Method)method)) {
            StringBuffer buf = new StringBuffer("proxy for service");
            if (target != null) {
                buf.append("[").append(target.toString()).append("]");
            }
            return buf.toString();
        }
        String serviceId = this.serviceIdAnaly.analyMethod(method);
        if (StringUtil.isBlank((String)serviceId)) {
            throw new RuntimeException(String.format("\u65b9\u6cd5:%s,\u672a\u53d1\u5e03\u6210\u670d\u52a1,\u4e0d\u80fd\u8fdb\u884c\u8bbf\u95ee", method));
        }
        ContextImpl context = new ContextImpl();
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(method);
        int size = paramNames != null ? paramNames.length : 0;
        int n = argSize = args != null ? args.length : 0;
        if (paramNames != null && args != null) {
            Assert.assertTrue((size == argSize ? 1 : 0) != 0, (String)"\u670d\u52a1\u914d\u7f6e\u63cf\u8ff0\u7684\u53c2\u6570\u4e2a\u6570\u4e0e\u5b9e\u9645\u65b9\u6cd5\u7684\u53c2\u6570\u4e2a\u6570\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        }
        for (int i = 0; i < size; ++i) {
            context.put(paramNames[i], args[i]);
        }
        return this.callServiceAndCallBack(serviceId, (Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event getEvent(String serviceId, Context context) throws Exception {
        Event event = new Event();
        event.setEventId(UUID.randomUUID().toString());
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setContext(context);
        serviceRequest.setServiceId(serviceId);
        try {
            String nodeName = InvokeNodeSetter.getNodeName();
            if (!StringUtil.isBlank((String)nodeName)) {
                serviceRequest.setNodeName(nodeName);
            }
        }
        finally {
            InvokeNodeSetter.removeNodeName();
        }
        event.setServiceRequest(serviceRequest);
        return event;
    }

    private <T> T callServiceAndCallBack(String serviceId, Context context) throws Exception {
        Event event = this.getEvent(serviceId, context);
        this.core.process(event);
        ServiceInfo info = this.core.getServiceInfo(serviceId);
        List resultsParam = info.getResults();
        if (resultsParam == null || resultsParam.size() == 0) {
            return null;
        }
        return (T)event.getServiceRequest().getContext().get(((Parameter)resultsParam.get(0)).getName());
    }
}

