/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.servicewrapper.config;

import java.lang.reflect.Method;

public class MethodDescription {
    private String className;
    private String methodName;
    private String parameterTypes;

    public static MethodDescription createMethodDescription(Method method) {
        MethodDescription description = new MethodDescription();
        description.setClassName(method.getDeclaringClass().getName());
        description.setMethodName(method.getName());
        Class<?>[] types = method.getParameterTypes();
        StringBuilder typeBuilder = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            typeBuilder.append(type.getName());
            if (i >= types.length - 1) continue;
            typeBuilder.append(";");
        }
        description.setParameterTypes(typeBuilder.toString());
        return description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(String parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDescription other = (MethodDescription)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes));
    }
}

