/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.templatespringext.FileProcessor;
import org.tinygroup.vfs.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileProcessor
implements FileProcessor {
    protected List<FileObject> fileList = new ArrayList<FileObject>();
    protected Map<String, FileObject> caches = new HashMap<String, FileObject>();
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileProcessor.class);

    @Override
    public void addFile(FileObject fileObject) {
        if (this.caches.containsKey(fileObject.getAbsolutePath()) && this.caches.get(fileObject.getAbsolutePath()).isModified()) {
            this.caches.remove(fileObject.getAbsolutePath());
            this.caches.put(fileObject.getAbsolutePath(), fileObject);
            return;
        }
        this.fileList.add(fileObject);
        this.caches.put(fileObject.getAbsolutePath(), fileObject);
    }

    @Override
    public void removeFile(FileObject fileObject) {
    }

    public List<FileObject> getFileObjectList() {
        return this.fileList;
    }
}

