/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.templatespringext.CallBackFunction;
import org.tinygroup.templatespringext.FileScanner;
import org.tinygroup.vfs.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileScanner
implements FileScanner {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileScanner.class);
    private List<String> classPathList = new ArrayList<String>();

    @Override
    public void setClassPathList(List<String> classPathList) {
        this.classPathList = classPathList;
    }

    protected List<String> getClassPathList() {
        return this.classPathList;
    }

    @Override
    public void addFile(FileObject file) {
    }

    @Override
    public void resolverFloder(FileObject file, CallBackFunction callBackFunction) {
        if (file.isFolder() && this.isMatch(file.getFileName())) {
            for (FileObject f : file.getChildren()) {
                this.resolverFloder(f, callBackFunction);
            }
        } else {
            callBackFunction.process(file);
        }
    }

    @Override
    public void resolverFile(FileObject file, CallBackFunction callBackFunction) {
        if (file.isFolder()) {
            for (FileObject f : file.getChildren()) {
                this.resolverFile(f, callBackFunction);
            }
        } else {
            callBackFunction.process(file);
        }
    }

    @Override
    public boolean isMatch(String fileName) {
        return !fileName.endsWith(".jar") && !this.classPathList.contains(fileName) && !fileName.equals("classes") && !fileName.equals("resources");
    }
}

