/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.impl;

import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.templatespringext.CallBackFunction;
import org.tinygroup.templatespringext.impl.AbstractFileScanner;
import org.tinygroup.templatespringext.processor.TinyJarFileProcessor;
import org.tinygroup.templatespringext.processor.TinyLocalPathProcessor;
import org.tinygroup.templatespringext.processor.TinyMacroProcessor;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.VFS;

public class FileScannerImpl
extends AbstractFileScanner {
    private TinyJarFileProcessor jarFileProcessor;
    private TinyMacroProcessor macroFileProcessor;
    private TinyLocalPathProcessor localPathProcessor;
    private TemplateEngine engine;

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public TinyJarFileProcessor getJarFileProcessor() {
        return this.jarFileProcessor;
    }

    public void setJarFileProcessor(TinyJarFileProcessor jarFileProcessor) {
        this.jarFileProcessor = jarFileProcessor;
    }

    public void init() {
        this.jarFileProcessor = this.jarFileProcessor == null ? new TinyJarFileProcessor() : this.jarFileProcessor;
        this.macroFileProcessor = new TinyMacroProcessor();
        this.localPathProcessor = new TinyLocalPathProcessor();
        this.jarFileProcessor.setEngine(this.engine);
        this.macroFileProcessor.setEngine(this.engine);
        this.localPathProcessor.setEngine(this.engine);
    }

    public void scanFile() {
        this.resolverFloder(VFS.resolveFile((String)"./"), new CallBackFunction(){

            public void process(FileObject fileObject) {
                if (FileScannerImpl.this.jarFileProcessor.isMatch(fileObject.getFileName())) {
                    FileScannerImpl.this.jarFileProcessor.addFile(fileObject);
                }
                if (FileScannerImpl.this.localPathProcessor.isMatch(fileObject.getFileName())) {
                    FileScannerImpl.this.localPathProcessor.addFile(fileObject);
                }
            }
        });
    }

    public void fileProcess() {
        this.localPathProcessor.process();
        this.classPathProcess();
        this.jarFileProcessor.process();
        for (FileObject file : this.jarFileProcessor.getFileObjectList()) {
            this.resolverFile(file, new CallBackFunction(){

                public void process(FileObject fileObject) {
                    if (FileScannerImpl.this.macroFileProcessor.isMatch(fileObject.getFileName())) {
                        FileScannerImpl.this.macroFileProcessor.addFile(fileObject);
                    }
                }
            });
        }
        for (String classPath : this.getClassPathList()) {
            this.resolverFile(VFS.resolveFile((String)classPath), new CallBackFunction(){

                public void process(FileObject fileObject) {
                    if (FileScannerImpl.this.macroFileProcessor.isMatch(fileObject.getFileName())) {
                        FileScannerImpl.this.macroFileProcessor.addFile(fileObject);
                    }
                }
            });
        }
        for (FileObject file : this.localPathProcessor.getFileObjectList()) {
            this.resolverFile(file, new CallBackFunction(){

                public void process(FileObject fileObject) {
                    if (FileScannerImpl.this.macroFileProcessor.isMatch(fileObject.getFileName())) {
                        FileScannerImpl.this.macroFileProcessor.addFile(fileObject);
                    }
                }
            });
        }
        this.macroFileProcessor.process();
    }

    public void classPathProcess() {
        for (String classPath : this.getClassPathList()) {
            this.engine.addResourceLoader((ResourceLoader)new FileObjectResourceLoader("page", "layout", "component", classPath));
        }
    }
}

