/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.processor;

import java.util.List;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.template.ResourceLoader;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.template.loader.FileObjectResourceLoader;
import org.tinygroup.templatespringext.impl.AbstractFileProcessor;
import org.tinygroup.vfs.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyJarFileProcessor
extends AbstractFileProcessor {
    private static final String JAR_FILE_EXT = ".jar";
    private TemplateEngine engine;
    private List<String> nameRule;

    public List<String> getNameRule() {
        return this.nameRule;
    }

    public void setNameRule(List<String> nameRule) {
        this.nameRule = nameRule;
    }

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean isMatch(String fileName) {
        return fileName.endsWith(JAR_FILE_EXT) && this.jarNameMatches(fileName);
    }

    public boolean jarNameMatches(String fileName) {
        for (String rule : this.nameRule) {
            if (!fileName.matches(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process() {
        if (this.fileList.size() > 0) {
            LOGGER.logMessage(LogLevel.INFO, "\u5f00\u59cb\u52a0\u8f7dJar\u6587\u4ef6...");
            for (FileObject file : this.fileList) {
                this.engine.addResourceLoader((ResourceLoader)new FileObjectResourceLoader("page", "layout", "component", file.getAbsolutePath()));
            }
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7dJar\u6587\u4ef6\u7ed3\u675f...");
        }
    }
}

