/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.templatespringext.springext;

import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.template.TemplateContext;
import org.tinygroup.template.TemplateEngine;
import org.tinygroup.templatespringext.springext.TinyWebTemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyTemplateLayoutView
extends AbstractTemplateView {
    private TemplateEngine templateEngine;
    private static final String VIEW_EXT_FILENAME = "page";
    private static final String PAGELET_EXT_FILE_NAME = "pagelet";
    private String viewExtFileName = "page";
    private String noLayoutExtFileName = "pagelet";
    private static final Logger logger = LoggerFactory.getLogger(TinyTemplateLayoutView.class);

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setViewExtFileName(String viewExtFileName) {
        this.viewExtFileName = viewExtFileName;
    }

    public void setNoLayoutExtFileName(String noLayoutExtFileName) {
        this.noLayoutExtFileName = noLayoutExtFileName;
    }

    public boolean checkResource(Locale locale) throws Exception {
        String path = this.getExtFileName(this.getUrl());
        try {
            this.templateEngine.findTemplate(path);
            return true;
        }
        catch (Exception e) {
            logger.logMessage(LogLevel.DEBUG, "Could not load tiny template for URL [{0}]", (Throwable)e, new Object[]{path});
            return false;
        }
    }

    private boolean isPagelet(String path) {
        return StringUtils.endsWith((String)path, (String)this.noLayoutExtFileName);
    }

    private String getExtFileName(String path) {
        if (this.isPagelet(path)) {
            return StringUtils.substringBeforeLast((String)path, (String)this.noLayoutExtFileName) + this.viewExtFileName;
        }
        return path;
    }

    protected void applyContentType(HttpServletResponse response) {
    }

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        long startTime = System.currentTimeMillis();
        TinyWebTemplateContext templateContext = new TinyWebTemplateContext(model);
        String path = this.getUrl();
        String extFileName = this.getExtFileName(path);
        if (this.isPagelet(path)) {
            this.templateEngine.renderTemplateWithOutLayout(extFileName, (TemplateContext)templateContext, (OutputStream)response.getOutputStream());
        } else {
            this.templateEngine.renderTemplate(extFileName, (TemplateContext)templateContext, (OutputStream)response.getOutputStream());
        }
        logger.logMessage(LogLevel.DEBUG, "\u8def\u5f84<{}>\u5904\u7406\u65f6\u95f4\uff1a{}ms", new Object[]{path, System.currentTimeMillis() - startTime});
    }
}

