/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.tinyrunner;

import java.io.InputStream;
import java.util.List;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.impl.ConfigurationFileProcessor;
import org.tinygroup.fileresolver.impl.FileResolverImpl;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.springutil.SpringBeanContainer;
import org.tinygroup.springutil.fileresolver.SpringBeansFileProcessor;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Runner {
    private static boolean init = false;
    private static Application application;
    private static String DEFAULT_CONFIG;
    private static final Logger LOGGER;
    private static final String TINY_JAR_PATTERN = "org\\.tinygroup\\.(.)*\\.jar";

    public static void init(String xmlFile, List<String> includePathPatterns) {
        if (init) {
            return;
        }
        Runner.initDirect(xmlFile, includePathPatterns);
    }

    public static void initDirect(String xmlFile, List<String> includePathPatterns) {
        InputStream inputStream;
        String configXml = xmlFile;
        if (null == configXml || "".equals(configXml)) {
            configXml = DEFAULT_CONFIG;
        }
        if ((inputStream = Runner.class.getClassLoader().getResourceAsStream(configXml)) == null) {
            inputStream = Runner.class.getResourceAsStream(configXml);
        }
        String applicationConfig = "";
        if (inputStream != null) {
            try {
                List processorConfigs;
                XmlNode applicationXml;
                applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)false);
                if (applicationConfig != null) {
                    ConfigurationManager c = ConfigurationUtil.getConfigurationManager();
                    applicationXml = ConfigurationUtil.loadApplicationConfig((String)applicationConfig);
                    c.setApplicationConfiguration(applicationXml);
                }
                application = new ApplicationDefault();
                Runner.initSpring(applicationConfig, includePathPatterns);
                FileResolver fileResolver = (FileResolver)BeanContainerFactory.getBeanContainer((ClassLoader)Runner.class.getClassLoader()).getBean("fileResolver");
                FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
                fileResolver.addResolvePath(FileResolverUtil.getClassPath((FileResolver)fileResolver));
                fileResolver.addResolvePath(FileResolverUtil.getWebClasses());
                try {
                    fileResolver.addResolvePath(FileResolverUtil.getWebLibJars((FileResolver)fileResolver));
                }
                catch (Exception e) {
                    LOGGER.errorMessage("\u4e3a\u6587\u4ef6\u626b\u63cf\u5668\u6dfb\u52a0webLibJars\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                fileResolver.addIncludePathPattern(TINY_JAR_PATTERN);
                Runner.addIncludePathPatterns(fileResolver, includePathPatterns);
                applicationXml = ConfigurationUtil.getConfigurationManager().getApplicationConfiguration();
                if (applicationXml != null && (processorConfigs = applicationXml.getSubNodesRecursively("application-processor")) != null) {
                    for (XmlNode processorConfig : processorConfigs) {
                        String processorBean = processorConfig.getAttribute("bean");
                        ApplicationProcessor processor = (ApplicationProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)Runner.class.getClassLoader()).getBean(processorBean);
                        application.addApplicationProcessor(processor);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.errorMessage("\u8f7d\u5165\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}\uff01", (Throwable)e, new Object[]{e.getMessage()});
                throw new RuntimeException(e);
            }
        }
        application.init();
        application.start();
        init = true;
    }

    private static void initSpring(String applicationConfig, List<String> includePathPatterns) {
        BeanContainerFactory.setBeanContainer((String)SpringBeanContainer.class.getName());
        FileResolverImpl fileResolver = new FileResolverImpl();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        fileResolver.addResolvePath(FileResolverUtil.getClassPath((FileResolver)fileResolver));
        fileResolver.addResolvePath(FileResolverUtil.getWebClasses());
        try {
            fileResolver.addResolvePath(FileResolverUtil.getWebLibJars((FileResolver)fileResolver));
        }
        catch (Exception e) {
            LOGGER.errorMessage("\u4e3a\u6587\u4ef6\u626b\u63cf\u5668\u6dfb\u52a0webLibJars\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        fileResolver.addIncludePathPattern(TINY_JAR_PATTERN);
        Runner.addIncludePathPatterns((FileResolver)fileResolver, includePathPatterns);
        Runner.loadFileResolverConfig((FileResolver)fileResolver, applicationConfig);
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new ConfigurationFileProcessor());
        fileResolver.resolve();
    }

    private static void loadFileResolverConfig(FileResolver fileResolver, String applicationConfig) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(applicationConfig).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        List classPathList = filter.findNodeList("/application/file-resolver-configuration/class-paths/class-path");
        for (XmlNode classPath : classPathList) {
            fileResolver.addResolvePath(classPath.getAttribute("path"));
        }
        List includePatternList = filter.findNodeList("/application/file-resolver-configuration/include-patterns/include-pattern");
        for (XmlNode includePatternNode : includePatternList) {
            fileResolver.addIncludePathPattern(includePatternNode.getAttribute("pattern"));
        }
    }

    private static void addIncludePathPatterns(FileResolver fileResolver, List<String> includePathPatterns) {
        if (includePathPatterns == null) {
            return;
        }
        for (String pattern : includePathPatterns) {
            fileResolver.addIncludePathPattern(pattern);
        }
    }

    public static void stop() {
        if (init) {
            application.stop();
        }
    }

    static {
        DEFAULT_CONFIG = "application.xml";
        LOGGER = LoggerFactory.getLogger(Runner.class);
    }
}

