package org.tinygroup.uienginestore;

import java.util.List;

/**
 * css资源管理器
 * @author yancheng11334
 *
 */
public interface MergeCssManager {

	 /**
	  * 获取合并的css资源
	  * @return
	  */
	 List<String> getCssResource();
	 
	 /**
	  * 设置css资源
	  * @param cssList
	  */
	 void setCssResource(List<String> cssList);
	 
	 /**
	  * 清理全部资源
	  */
	 void clear();
	 
	 /**
	  * 添加单个css资源
	  * @param css
	  */
     void addCssResource(String css);
     
     /**
	  * 删除单个css资源
	  * @param css
	  */
     void removeCssResource(String css);
     
}
