package org.tinygroup.uienginestore;

import java.util.ArrayList;
import java.util.List;

/**
 * 定义保存属性
 * @author yancheng11334
 *
 */
public class StoreConfig {

	private boolean mergeTag;
	
	private boolean synStore;
	
	private int threadNum;
	
	private String mergeCssName;
	
	private String mergeJsName;
	
	private List<String> includePatterns = new ArrayList<String>();
	
	private List<String> excludePatterns = new ArrayList<String>();
	
	private String storePath;
	
	private long cssLimit;

	public boolean isMergeTag() {
		return mergeTag;
	}

	public void setMergeTag(boolean mergeTag) {
		this.mergeTag = mergeTag;
	}

	public boolean isSynStore() {
		return synStore;
	}

	public void setSynStore(boolean synStore) {
		this.synStore = synStore;
	}

	public long getCssLimit() {
		return cssLimit;
	}

	public void setCssLimit(long cssLimit) {
		this.cssLimit = cssLimit;
	}

	public int getThreadNum() {
		return threadNum;
	}

	public void setThreadNum(int threadNum) {
		this.threadNum = threadNum;
	}

	public String getMergeCssName() {
		return mergeCssName;
	}

	public void setMergeCssName(String mergeCssName) {
		this.mergeCssName = mergeCssName;
	}

	public String getMergeJsName() {
		return mergeJsName;
	}

	public void setMergeJsName(String mergeJsName) {
		this.mergeJsName = mergeJsName;
	}

	public String getStorePath() {
		return storePath;
	}

	public void setStorePath(String storePath) {
		this.storePath = storePath;
	}

	public List<String> getIncludePatterns() {
		if(includePatterns==null){
		   includePatterns = new ArrayList<String>();
		}
		return includePatterns;
	}
	
	public void addIncludePattern(String includePattern){
		getIncludePatterns().add(includePattern);
	}

	public void setIncludePatterns(List<String> includePatterns) {
		this.includePatterns = includePatterns;
	}

	public List<String> getExcludePatterns() {
		if(excludePatterns==null){
		   excludePatterns = new ArrayList<String>();
		}
		return excludePatterns;
	}
	
	public void addExcludePattern(String excludePattern){
		getExcludePatterns().add(excludePattern);
	}

	public void setExcludePatterns(List<String> excludePatterns) {
		this.excludePatterns = excludePatterns;
	}
	
}
