/**
 * Copyright (c) 2012-2016, www.tinygroup.org (luo_guo@icloud.com).
 * <p>
 * Licensed under the GPL, Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/gpl.html
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.tinygroup.uienginestore;

import org.tinygroup.vfs.FileObject;

import java.util.List;

/**
 * UI资源处理器
 * @author yancheng11334
 *
 */
public interface UIOperator {

    /**
     * 生成JS资源
     * @param config
     * @return
     * @throws Exception
     */
    List<FileObject> createJS(StoreConfig config) throws Exception;

    /**
     * 生成CSS资源
     * @param contextPath
     * @param servletPath
     * @param config
     * @return
     * @throws Exception
     */
    List<FileObject> createCSS(String contextPath, String servletPath, StoreConfig config) throws Exception;
}
