/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.urlrestful.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.urlrestful.UrlRestfulManager;
import org.tinygroup.urlrestful.config.Rules;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xstream.XStreamFactory;

public class UrlRestfulFileProcessor
extends AbstractFileProcessor {
    private static final String RESTFUL_EXT_FILENAME = ".restful.xml";
    private UrlRestfulManager urlRestfulManager;

    public boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().toLowerCase().endsWith(RESTFUL_EXT_FILENAME);
    }

    public void setUrlRestfulManager(UrlRestfulManager urlRestfulManager) {
        this.urlRestfulManager = urlRestfulManager;
    }

    public void process() {
        Rules Rules2;
        XStream stream = XStreamFactory.getXStream((String)"urlrestful");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664restful\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Rules2 = (Rules)this.caches.get(fileObject.getAbsolutePath());
            if (Rules2 != null) {
                this.urlRestfulManager.removeRules(Rules2);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.logMessage(LogLevel.INFO, "\u79fb\u9664restful\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u52a0\u8f7drestful\u6587\u4ef6[{0}]", new Object[]{fileObject.getAbsolutePath()});
            Rules2 = (Rules)stream.fromXML(fileObject.getInputStream());
            Rules oldRules = (Rules)this.caches.get(fileObject.getAbsolutePath());
            if (oldRules != null) {
                this.urlRestfulManager.removeRules(oldRules);
            }
            this.urlRestfulManager.addRules(Rules2);
            this.caches.put(fileObject.getAbsolutePath(), Rules2);
            LOGGER.logMessage(LogLevel.INFO, "\u52a0\u8f7drestful\u6587\u4ef6[{0}]\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
    }
}

