/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.urlrestful.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.urlrestful.Context;
import org.tinygroup.urlrestful.UrlRestfulManager;
import org.tinygroup.urlrestful.ValueConverter;
import org.tinygroup.urlrestful.valueparser.DefaultValueConverter;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ParameterParser;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionContext;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulStyleSubstitutionHandler
implements RewriteSubstitutionHandler {
    private static final String Accept = "Accept";
    private static final String HTTP_METHOD_KEY = "X-HTTP-METHOD-OVERRIDE";
    private UrlRestfulManager urlRestfulManager;
    private List<ValueConverter> converters = new ArrayList<ValueConverter>();

    public void setUrlRestfulManager(UrlRestfulManager urlRestfulManager) {
        this.urlRestfulManager = urlRestfulManager;
    }

    public void addConvert(ValueConverter converter) {
        this.converters.add(converter);
    }

    public void removeConvert(ValueConverter converter) {
        this.converters.remove(converter);
    }

    public void postSubstitution(RewriteSubstitutionContext context) {
        String requestAccept;
        String httpMethod;
        String orignalPath = context.getPath();
        Context restfulContext = this.urlRestfulManager.getContext(orignalPath, httpMethod = this.getHttpMethod(context), requestAccept = (String)context.getParserWebContext().get(Accept));
        if (restfulContext != null) {
            ParameterParser parameterParser = context.getParameters();
            this.setParameter(parameterParser, restfulContext.getVariableMap());
            context.setPath(restfulContext.getMappingUrl());
        }
    }

    private String getHttpMethod(RewriteSubstitutionContext context) {
        ParserWebContext webContext = context.getParserWebContext();
        String httpMethod = (String)webContext.get(HTTP_METHOD_KEY);
        if (StringUtil.isBlank((String)httpMethod)) {
            httpMethod = webContext.getRequest().getMethod();
        }
        return httpMethod;
    }

    private void setParameter(ParameterParser parameterParser, Map<String, String> variableMap) {
        if (!CollectionUtil.isEmpty(variableMap)) {
            for (String key : variableMap.keySet()) {
                String value = variableMap.get(key);
                if (StringUtil.isBlank((String)value)) continue;
                ValueConverter converter = this.findConvert(value);
                parameterParser.setObject(key, converter.convert(value));
            }
        }
    }

    private ValueConverter findConvert(String value) {
        for (ValueConverter converter : this.converters) {
            if (!converter.isMatch(value)) continue;
            return converter;
        }
        return new DefaultValueConverter();
    }
}

