/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.urlrestful.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.match.AntPathStringMatcher;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.urlrestful.Context;
import org.tinygroup.urlrestful.UrlRestfulManager;
import org.tinygroup.urlrestful.config.Mapping;
import org.tinygroup.urlrestful.config.Rule;
import org.tinygroup.urlrestful.config.Rules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlRestfulManagerImpl
implements UrlRestfulManager {
    private List<Rule> restfulContainer = new ArrayList<Rule>();

    @Override
    public void addRules(Rules Rules2) {
        this.restfulContainer.addAll(Rules2.getRules());
    }

    @Override
    public void removeRules(Rules Rules2) {
        this.restfulContainer.removeAll(Rules2.getRules());
    }

    @Override
    public Context getContext(String requestPath, String httpMethod, String accept) {
        String requestAccept = accept;
        if (StringUtil.isBlank((String)requestAccept)) {
            requestAccept = "text/html";
        }
        for (Rule rule : this.restfulContainer) {
            List<Mapping> mappings;
            Mapping mapping;
            AntPathStringMatcher matcher = new AntPathStringMatcher(rule.getPattern(), requestPath);
            if (!matcher.matches() || (mapping = this.getUrlMapping(requestAccept, mappings = rule.getUrlMappingsByMethod(httpMethod))) == null) continue;
            return new Context(rule, mapping, matcher.getUriTemplateVariables());
        }
        return null;
    }

    private Mapping getUrlMapping(String requestContentType, List<Mapping> mappings) {
        if (!CollectionUtil.isEmpty(mappings)) {
            for (Mapping mapping : mappings) {
                String contentType = mapping.getAccept();
                if (requestContentType == null || requestContentType.indexOf(contentType) == -1) continue;
                return mapping;
            }
        }
        return null;
    }
}

