/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.urlrestful.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.urlrestful.config.Mapping;

@XStreamAlias(value="rule")
public class Rule {
    @XStreamAsAttribute
    private String pattern;
    @XStreamImplicit
    private List<Mapping> mappings;
    private transient Map<String, List<Mapping>> method2Mapping;

    public Rule(String pattern) {
        this.pattern = pattern;
    }

    private void addUrlMapping(Mapping mapping) {
        List<Mapping> mappings = this.method2Mapping.get(mapping.getMethod());
        if (mappings == null) {
            mappings = new ArrayList<Mapping>();
            this.method2Mapping.put(mapping.getMethod(), mappings);
        }
        mappings.add(mapping);
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<Mapping> getUrlMappingsByMethod(String method) {
        if (this.method2Mapping == null) {
            this.init();
        }
        return this.method2Mapping.get(method);
    }

    public List<Mapping> getMappings() {
        if (this.mappings == null) {
            this.mappings = new ArrayList<Mapping>();
        }
        return this.mappings;
    }

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    public void init() {
        this.method2Mapping = new CaseInsensitiveMap();
        if (!CollectionUtil.isEmpty(this.mappings)) {
            for (Mapping mapping : this.mappings) {
                this.addUrlMapping(mapping);
            }
        }
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rule) {
            Rule other = (Rule)obj;
            return other.pattern.equals(this.pattern);
        }
        return false;
    }
}

