/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.IOException;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandler;
import org.tinygroup.weblayer.exceptionhandler.impl.WebExceptionHandlerManagerImpl;
import org.tinygroup.weblayer.impl.WebContextImpl;

public class ExceptionHandlerTest
extends TestCase {
    public void testHandler() throws Exception {
        WebExceptionHandlerManagerImpl webExceptionHandlerManager = new WebExceptionHandlerManagerImpl();
        final State state = new State(true);
        webExceptionHandlerManager.setDefaultHandler(new WebExceptionHandler(){

            public void handler(Throwable throwable, WebContext webContext) throws IOException, ServletException {
                state.setDefault(true);
                System.out.println("defaultHandler be treated");
            }
        });
        webExceptionHandlerManager.addHandler(IllegalArgumentException.class.getName(), new WebExceptionHandler(){

            public void handler(Throwable throwable, WebContext webContext) throws IOException, ServletException {
                state.setDefault(false);
                System.out.println("IllegalArgumentException be treated");
            }
        });
        webExceptionHandlerManager.addHandler(ArrayIndexOutOfBoundsException.class.getName(), new WebExceptionHandler(){

            public void handler(Throwable throwable, WebContext webContext) throws IOException, ServletException {
                state.setDefault(false);
                System.out.println("ArrayIndexOutOfBoundsException be treated");
            }
        });
        webExceptionHandlerManager.addHandler(ClassNotFoundException.class.getName(), new WebExceptionHandler(){

            public void handler(Throwable throwable, WebContext webContext) throws IOException, ServletException {
                state.setDefault(false);
                System.out.println("ClassNotFoundException be treated");
            }
        });
        WebContextImpl webContext = new WebContextImpl();
        webExceptionHandlerManager.handler((Throwable)new IllegalArgumentException("sdsff"), (WebContext)webContext);
        ExceptionHandlerTest.assertEquals((boolean)false, (boolean)state.isDefault());
        webExceptionHandlerManager.handler((Throwable)new ArrayIndexOutOfBoundsException("sfdsf"), (WebContext)webContext);
        ExceptionHandlerTest.assertEquals((boolean)false, (boolean)state.isDefault());
        webExceptionHandlerManager.handler((Throwable)new TestException("sfdsf"), (WebContext)webContext);
        ExceptionHandlerTest.assertEquals((boolean)false, (boolean)state.isDefault());
        webExceptionHandlerManager.handler((Throwable)new IllegalAccessException("sfdsf"), (WebContext)webContext);
        ExceptionHandlerTest.assertEquals((boolean)true, (boolean)state.isDefault());
        webExceptionHandlerManager.handler((Throwable)new IllegalStateException(new IllegalArgumentException(new TestException("ssff"))), (WebContext)webContext);
        ExceptionHandlerTest.assertEquals((boolean)false, (boolean)state.isDefault());
    }

    private class TestException
    extends ClassNotFoundException {
        public TestException() {
        }

        public TestException(String s, Throwable ex) {
            super(s, ex);
        }

        public TestException(String s) {
            super(s);
        }
    }

    private class State {
        private boolean isDefault;

        public State(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }
    }
}

