/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.exceptionhandler.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandler;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandlerManager;
import org.tinygroup.weblayer.exceptionhandler.impl.DefaultWebExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebExceptionHandlerManagerImpl
implements WebExceptionHandlerManager {
    private Map<String, WebExceptionHandler> handlerNameMap = new HashMap<String, WebExceptionHandler>();
    private Map<Class<?>, WebExceptionHandler> handlerMap = new HashMap();
    private List<Class<?>> exceptionList = new ArrayList();
    private WebExceptionHandler defaultHandler = new DefaultWebExceptionHandler();

    @Override
    public void addHandler(String exception, WebExceptionHandler handler) throws ClassNotFoundException {
        if (this.handlerNameMap.containsKey(exception)) {
            return;
        }
        this.handlerNameMap.put(exception, handler);
        Class<?> exceptionClass = Class.forName(exception);
        this.exceptionList.add(exceptionClass);
        this.handlerMap.put(exceptionClass, handler);
    }

    @Override
    public boolean handler(Throwable e, WebContext webContext) throws IOException, ServletException {
        boolean isProcessed = this.exceptionHandler(e, webContext);
        if (isProcessed) {
            return true;
        }
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            isProcessed = this.exceptionHandler(t, webContext);
            if (!isProcessed) continue;
            return true;
        }
        if (this.defaultHandler != null) {
            this.defaultHandler.handler(e, webContext);
            return true;
        }
        return false;
    }

    private boolean exceptionHandler(Throwable e, WebContext webContext) throws IOException, ServletException {
        Class<?> exceptionClass = e.getClass();
        int index = this.exceptionList.indexOf(exceptionClass);
        if (index != -1) {
            this.handlerMap.get(this.exceptionList.get(index)).handler(e, webContext);
            return true;
        }
        for (int i = 0; i < this.exceptionList.size(); ++i) {
            Class<?> clazz = this.exceptionList.get(i);
            if (!this.implmentInterface(exceptionClass, clazz)) continue;
            this.handlerMap.get(clazz).handler(e, webContext);
            return true;
        }
        return false;
    }

    private boolean implmentInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    @Override
    public void setDefaultHandler(WebExceptionHandler handler) {
        this.defaultHandler = handler;
    }
}

