/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.fileresolver;

import com.thoughtworks.xstream.XStream;
import org.tinygroup.fileresolver.impl.AbstractFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.config.TinyFilterConfigInfos;
import org.tinygroup.weblayer.configmanager.TinyFilterConfigManager;
import org.tinygroup.xstream.XStreamFactory;

public class TinyFilterFileProcessor
extends AbstractFileProcessor {
    private static final String FILTERS_EXT_FILENAMES = ".tinyfilters.xml";
    private TinyFilterConfigManager configManager;

    public TinyFilterConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(TinyFilterConfigManager configManager) {
        this.configManager = configManager;
    }

    public void process() {
        TinyFilterConfigInfos oldConfigs;
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (FileObject fileObject : this.deleteList) {
            LOGGER.log(LogLevel.INFO, "\u6b63\u5728\u79fb\u9664tiny-filter\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            oldConfigs = (TinyFilterConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                this.configManager.removeConfig(oldConfigs);
                this.caches.remove(fileObject.getAbsolutePath());
            }
            LOGGER.log(LogLevel.INFO, "\u79fb\u9664tiny-filter\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>\u7ed3\u675f", new Object[]{fileObject.getAbsolutePath()});
        }
        for (FileObject fileObject : this.changeList) {
            oldConfigs = (TinyFilterConfigInfos)this.caches.get(fileObject.getAbsolutePath());
            if (oldConfigs != null) {
                this.configManager.removeConfig(oldConfigs);
            }
            LOGGER.log(LogLevel.INFO, "\u627e\u5230tiny-filter\u63cf\u8ff0\u6587\u4ef6\uff1a<{}>", new Object[]{fileObject.getAbsolutePath()});
            TinyFilterConfigInfos configInfos = (TinyFilterConfigInfos)stream.fromXML(fileObject.getInputStream());
            this.configManager.addConfig(configInfos);
            this.caches.put(fileObject.getAbsolutePath(), configInfos);
        }
        this.configManager.combineConfig();
    }

    protected boolean checkMatch(FileObject fileObject) {
        return fileObject.getFileName().endsWith(FILTERS_EXT_FILENAMES);
    }
}

