/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.filter.gzip.GZIPResponseStream;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected PrintWriter writer = null;
    private Logger logger = LoggerFactory.getLogger(GZIPResponseWrapper.class);

    public GZIPResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new GZIPResponseStream(this.baos);
    }

    public PrintWriter getWriter() throws IOException {
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.baos, super.getCharacterEncoding()));
        return this.writer;
    }

    public byte[] getBufferedBytes() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.baos.flush();
        }
        catch (IOException e) {
            this.logger.errorMessage(e.getMessage(), (Throwable)e);
        }
        byte[] byteArray = this.baos.toByteArray();
        return byteArray;
    }
}

