/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.springframework.web.util.NestedServletException;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.order.OrderUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyProcessor;
import org.tinygroup.weblayer.TinyProcessorConfig;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.config.TinyProcessorConfigInfo;
import org.tinygroup.weblayer.configmanager.TinyProcessorConfigManager;
import org.tinygroup.weblayer.impl.DefaultTinyProcessorConfig;

public class TinyProcessorManagerImpl
implements TinyProcessorManager {
    private List<TinyProcessor> tinyProcessorList = new ArrayList<TinyProcessor>();
    private Map<String, TinyProcessorConfig> processorMap = new HashMap<String, TinyProcessorConfig>();
    private TinyProcessorConfigManager configManager;
    private static Logger logger = LoggerFactory.getLogger(TinyProcessorManagerImpl.class);

    public boolean execute(String url, WebContext context) throws ServletException, IOException {
        boolean canExecute = false;
        for (TinyProcessor tinyProcessor : this.tinyProcessorList) {
            if (!tinyProcessor.isMatch(url)) continue;
            canExecute = true;
            tinyProcessor.process(url, context);
            break;
        }
        return canExecute;
    }

    public void initTinyResources() throws ServletException {
        this.reset();
        Throwable failureCause = null;
        try {
            this.addTinyProcessor();
            OrderUtil.order(this.tinyProcessorList);
            this.initTinyProcessor();
        }
        catch (ServletException ex) {
            failureCause = ex;
            throw ex;
        }
        catch (Throwable ex) {
            failureCause = ex;
            throw new NestedServletException("filter init processing failed", ex);
        }
        finally {
            if (failureCause != null) {
                logger.errorMessage("Could not init processor", failureCause);
            } else {
                logger.logMessage(LogLevel.DEBUG, "Successfully completed processor init");
            }
        }
    }

    private void initTinyProcessor() throws ServletException {
        for (TinyProcessor tinyProcessor : this.tinyProcessorList) {
            logger.logMessage(LogLevel.DEBUG, "tiny processor name:[{0}] start init", new Object[]{tinyProcessor.getProcessorName()});
            tinyProcessor.init(this.processorMap.get(tinyProcessor.getProcessorName()));
            logger.logMessage(LogLevel.DEBUG, "tiny processor name:[{0}] init end", new Object[]{tinyProcessor.getProcessorName()});
        }
    }

    private void addTinyProcessor() {
        List<TinyProcessorConfigInfo> processorConfigs = this.configManager.getProcessorConfigs();
        for (TinyProcessorConfigInfo processorConfig : processorConfigs) {
            this.tinyProcessorList.add(this.createTinyProcessor(processorConfig));
            this.processorMap.put(processorConfig.getConfigName(), new DefaultTinyProcessorConfig(processorConfig));
        }
    }

    private TinyProcessor createTinyProcessor(TinyProcessorConfigInfo processorConfigInfo) {
        String processorName = processorConfigInfo.getConfigName();
        logger.logMessage(LogLevel.INFO, "tiny-processor:{}\u5f00\u59cb\u88ab\u5b9e\u4f8b\u5316", new Object[]{processorName});
        TinyProcessor processor = this.instanceProcessor(processorConfigInfo.getConfigBeanName());
        processor.setProcessorName(processorName);
        logger.logMessage(LogLevel.INFO, "tiny-processor:{}\u5b9e\u4f8b\u5316\u7ed3\u675f", new Object[]{processorName});
        return processor;
    }

    private TinyProcessor instanceProcessor(String beanName) {
        TinyProcessor processor = (TinyProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
        return processor;
    }

    public void reset() {
        this.tinyProcessorList = new ArrayList<TinyProcessor>();
        this.processorMap = new HashMap<String, TinyProcessorConfig>();
    }

    public void setConfigManager(TinyProcessorConfigManager configManager) {
        this.configManager = configManager;
    }

    public void destoryTinyResources() {
        for (TinyProcessor tinyProcessor : this.tinyProcessorList) {
            tinyProcessor.destroy();
        }
        this.tinyProcessorList = null;
        this.processorMap = null;
    }
}

