/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.listener;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.Enumerator;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;

public class TinyServletContext
implements ServletContext {
    private ServletContext originalContext;
    private FullContextFileRepository fullContextFileRepository;
    private Map<String, String> parameters = new HashMap<String, String>();
    private TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyServletContext.class);

    public TinyServletContext(ServletContext servletContext) {
        Assert.assertNotNull((Object)servletContext, (String)"servletContext must not null", (Object[])new Object[0]);
        this.originalContext = servletContext;
    }

    public String getContextPath() {
        return this.originalContext.getContextPath();
    }

    public ServletContext getContext(String uripath) {
        return this.originalContext.getContext(uripath);
    }

    public int getMajorVersion() {
        return this.originalContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.originalContext.getMinorVersion();
    }

    public String getMimeType(String file) {
        return this.originalContext.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        return this.originalContext.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        FileObject fileObject;
        if (this.fullContextFileRepository != null && (fileObject = this.fullContextFileRepository.getFileObject(path)) != null && fileObject.isExist()) {
            return fileObject.getURL();
        }
        return this.originalContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        FileObject fileObject;
        if (this.fullContextFileRepository != null && (fileObject = this.fullContextFileRepository.getFileObject(path)) != null && fileObject.isExist()) {
            return fileObject.getInputStream();
        }
        return this.originalContext.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.originalContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.originalContext.getNamedDispatcher(name);
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.originalContext.getServlet(name);
    }

    @Deprecated
    public Enumeration getServlets() {
        return this.originalContext.getServlets();
    }

    public Enumeration getServletNames() {
        return this.originalContext.getServletNames();
    }

    public void log(String msg) {
        this.originalContext.log(msg);
    }

    @Deprecated
    public void log(Exception exception, String msg) {
        this.originalContext.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.originalContext.log(message, throwable);
    }

    public String getRealPath(String path) {
        FileObject fileObject;
        String realPath = this.originalContext.getRealPath(path);
        if (StringUtil.isBlank((String)realPath) && this.fullContextFileRepository != null && (fileObject = this.fullContextFileRepository.getFileObject(path)) != null && fileObject.isExist()) {
            return fileObject.getAbsolutePath();
        }
        return realPath;
    }

    public String getServerInfo() {
        return this.originalContext.getServerInfo();
    }

    public String getInitParameter(String name) {
        String value = this.parameters.get(name);
        if (value == null) {
            value = this.originalContext.getInitParameter(name);
        }
        return value;
    }

    public Enumeration getInitParameterNames() {
        Enumeration enumeration = this.originalContext.getInitParameterNames();
        HashSet<String> parameterSet = new HashSet<String>();
        parameterSet.addAll(this.parameters.keySet());
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            parameterSet.add(name);
        }
        return new Enumerator(parameterSet);
    }

    public Object getAttribute(String name) {
        return this.originalContext.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.originalContext.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        Object oldValue = this.getAttribute(name);
        this.originalContext.setAttribute(name, object);
        this.setAttributeListener(name, object, oldValue);
    }

    private void setAttributeListener(String name, Object object, Object oldValue) {
        List<ServletContextAttributeListener> contextAttributeListeners = this.configManager.getContextAttributeListeners();
        ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, object);
        if (oldValue == null) {
            for (ServletContextAttributeListener listener : contextAttributeListeners) {
                LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] will be attributeAdded", new Object[]{listener});
                listener.attributeAdded(event);
                LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] attributeAdded", new Object[]{listener});
            }
        } else {
            for (ServletContextAttributeListener listener : contextAttributeListeners) {
                LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] will be attributeReplaced,the oldValue:[{1}]", new Object[]{listener, oldValue});
                listener.attributeReplaced(event);
                LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] attributeReplaced", new Object[]{listener});
            }
        }
    }

    public void removeAttribute(String name) {
        this.originalContext.removeAttribute(name);
        this.removeAttributeListener(name);
    }

    private void removeAttributeListener(String name) {
        List<ServletContextAttributeListener> contextAttributeListeners = this.configManager.getContextAttributeListeners();
        ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, null);
        for (ServletContextAttributeListener listener : contextAttributeListeners) {
            LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] will be attributeRemoved", new Object[]{listener});
            listener.attributeRemoved(event);
            LOGGER.logMessage(LogLevel.DEBUG, "ServletContextAttributeListener:[{0}] attributeRemoved", new Object[]{listener});
        }
    }

    public String getServletContextName() {
        return this.originalContext.getServletContextName();
    }

    public void setInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setFullContextFileRepository(FullContextFileRepository fullContextFileRepository) {
        this.fullContextFileRepository = fullContextFileRepository;
    }
}

