/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.TinyProcessorManager;
import org.tinygroup.weblayer.impl.WebContextImpl;
import org.tinygroup.weblayer.listener.ServletContextHolder;

public class TinyServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(TinyServlet.class);
    TinyProcessorManager tinyProcessorManager;

    public void init() throws ServletException {
        this.tinyProcessorManager = (TinyProcessorManager)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean("tinyProcessorManager");
        this.tinyProcessorManager.initTinyResources();
    }

    public void init(ServletConfig config) throws ServletException {
        this.init();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = request.getPathInfo();
        }
        logger.logMessage(LogLevel.DEBUG, "servlet\u8bf7\u6c42\u8def\u5f84\uff1a<{}>", new Object[]{servletPath});
        WebContextImpl context = new WebContextImpl();
        context.init(request, response, ServletContextHolder.getServletContext());
        this.tinyProcessorManager.execute(servletPath, context);
    }

    public void destroy() {
        this.tinyProcessorManager.destoryTinyResources();
        this.tinyProcessorManager = null;
    }
}

