/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.mvc.HandlerExecutionChain;
import org.tinygroup.weblayer.mvc.HandlerMapping;
import org.tinygroup.weblayer.mvc.MappingModelExecute;

public class MvcTinyProcessor
extends AbstractTinyProcessor {
    private HandlerMapping handler;
    private MappingModelExecute execute;
    private static final Logger logger = LoggerFactory.getLogger(MvcTinyProcessor.class);

    public HandlerMapping getHandler() {
        return this.handler;
    }

    public void setHandler(HandlerMapping handler) {
        this.handler = handler;
    }

    public MappingModelExecute getExecute() {
        return this.execute;
    }

    public void setExecute(MappingModelExecute execute) {
        this.execute = execute;
    }

    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        HttpServletRequest request = context.getRequest();
        logger.logMessage(LogLevel.DEBUG, "mvc-tiny-processor processing:[{}] request for [{}]", new Object[]{request.getMethod(), urlString});
        HandlerExecutionChain chain = this.handler.getHandler(urlString);
        if (chain != null) {
            this.execute.execute(chain, context);
        } else {
            logger.logMessage(LogLevel.ERROR, "\u8bf7\u6c42\u8def\u5f84:{}\u627e\u4e0d\u5230\u5904\u7406\u6620\u5c04", new Object[]{urlString});
        }
    }

    protected void customInit() throws ServletException {
        if (this.handler == null) {
            this.handler = (HandlerMapping)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("annotationHandlerMapping");
        }
        if (this.execute == null) {
            this.execute = (MappingModelExecute)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("mappingModelExecute");
        }
        this.handler.init();
    }
}

