/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.context.Context;
import org.tinygroup.convert.objectjson.fastjson.ObjectToJson;
import org.tinygroup.convert.objectxml.xstream.ObjectToXml;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.exception.BaseRuntimeException;
import org.tinygroup.exception.Result;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class ServiceOutPutTinyProcessor
extends AbstractTinyProcessor {
    private CEPCore core;
    private ObjectToXml<Object> objectToXml = new ObjectToXml();
    private ObjectToJson<Object> objectToJson = new ObjectToJson(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }

    private Object callService(String serviceId, Context context) {
        Event event = new Event();
        ServiceRequest sq = new ServiceRequest();
        sq.setServiceId(serviceId);
        sq.setContext(context);
        event.setServiceRequest(sq);
        this.core.process(event);
        ServiceInfo info = this.core.getServiceInfo(serviceId);
        List resultsParam = info.getResults();
        if (resultsParam == null || resultsParam.size() == 0) {
            return null;
        }
        return event.getServiceRequest().getContext().get(((Parameter)resultsParam.get(0)).getName());
    }

    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        Result result = new Result();
        try {
            int lastSplash = urlString.lastIndexOf(47);
            int lastDot = urlString.lastIndexOf(46);
            String serviceId = urlString.substring(lastSplash + 1, lastDot);
            Object objectResult = this.callService(serviceId, context);
            result.setResultObj(objectResult);
            result.setSuccess(true);
        }
        catch (Exception exception) {
            result.setSuccess(false);
            result.setErrorContext(BaseRuntimeException.getErrorContext((Throwable)exception));
        }
        if (urlString.endsWith(".sxml")) {
            context.getResponse().getWriter().write(this.objectToXml.convert((Object)result));
        } else if (urlString.endsWith(".sjson")) {
            context.getResponse().getWriter().write(this.objectToJson.convert((Object)result));
        }
    }

    protected void customInit() throws ServletException {
    }
}

