/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.context.Context;
import org.tinygroup.context.impl.ContextImpl;
import org.tinygroup.weblayer.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebContextWrapper
extends ContextImpl
implements WebContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private WebContext wrappedContext;
    private Map<String, WebContextScope> scopes = new HashMap<String, WebContextScope>();
    private ParamNameVerificationSupport verificationSupport;

    public AbstractWebContextWrapper() {
        this.scopes.put("requestScope", new RequestScope());
        this.scopes.put("sessionScope", new SessionScope());
        this.scopes.put("applicationScope", new ApplicationScope());
    }

    public AbstractWebContextWrapper(WebContext wrappedContext) {
        this.scopes.put("requestScope", new RequestScope());
        this.scopes.put("sessionScope", new SessionScope());
        this.scopes.put("applicationScope", new ApplicationScope());
        Assert.assertNotNull((Object)wrappedContext, (String)"wrappedContext", (Object[])new Object[0]);
        this.wrappedContext = wrappedContext;
        this.request = wrappedContext.getRequest();
        this.response = wrappedContext.getResponse();
        this.servletContext = wrappedContext.getServletContext();
        this.verificationSupport = new ParamNameVerificationSupport(this.request);
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
        super.put("httpServletResponse", (Object)response);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    private <T> T findInRequest(String name) {
        if (this.request != null) {
            return (T)this.verificationSupport.getValue(name);
        }
        return null;
    }

    private boolean existInRequest(String name) {
        if (this.request != null) {
            return this.verificationSupport.isExist(name);
        }
        return false;
    }

    public <T> T get(String name) {
        T result = this.getFromWrapperContext(name, this);
        if (result != null) {
            return result;
        }
        return this.findInRequest(name);
    }

    public boolean exist(String name) {
        boolean exist = this.existFromWrapperContext(name, this);
        if (exist) {
            return true;
        }
        return this.existInRequest(name);
    }

    protected <T> T getFromWrapperContext(String name, WebContext webContext) {
        T result = this.getFromSubContext(name, webContext);
        if (result != null) {
            return result;
        }
        if (webContext.getWrappedWebContext() != null && (result = this.getFromWrapperContext(name, webContext.getWrappedWebContext())) != null) {
            return result;
        }
        return null;
    }

    protected boolean existFromWrapperContext(String name, WebContext webContext) {
        boolean exist = this.existFromSubContext(name, webContext);
        if (exist) {
            return true;
        }
        return webContext.getWrappedWebContext() != null && (exist = this.existFromWrapperContext(name, webContext.getWrappedWebContext()));
    }

    private <T> T getFromSubContext(String name, Context context) {
        HashMap nodeMap = new HashMap();
        return (T)this.findNodeMap(name, context, nodeMap);
    }

    private boolean existFromSubContext(String name, Context context) {
        HashMap nodeMap = new HashMap();
        return this.existNodeMap(name, context, nodeMap);
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
        super.put("httpServletRequest", (Object)request);
    }

    @Override
    public void init(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.setRequest(request);
        this.setResponse(response);
        this.setServletContext(servletContext);
        this.putRequestInfo(request);
        this.verificationSupport = new ParamNameVerificationSupport(request);
    }

    private void putRequestInfo(HttpServletRequest request) {
        this.put("tinyRequestRemoteAddr", request.getRemoteAddr());
        this.put("tinyRequestRemoteHost", request.getRemoteHost());
        this.put("tinyRequestRemoteUser", request.getRemoteUser());
        this.put("tinyRequestScheme", request.getScheme());
        this.put("tinyRequestServerName", request.getServerName());
        this.put("tinyRequestServletPath", request.getServletPath());
        this.put("tinyRequestServerPort", request.getServerPort());
        this.put("tinyRequestAuthType", request.getAuthType());
        this.put("tinyRequestEncoding", request.getCharacterEncoding());
        this.put("tinyRequestContentType", request.getContentType());
        this.put("tinyRequestContextPath", request.getContextPath());
        this.put("tinyRequestLocalAddr", request.getLocalAddr());
        this.put("tinyRequestLocalName", request.getLocalName());
        this.put("tinyRequestLocalPort", request.getLocalPort());
        this.put("tinyRequestPathInfo", request.getPathInfo());
        this.put("tinyRequestLocalName", request.getPathTranslated());
        this.put("tinyRequestProtocol", request.getProtocol());
        this.put("tinyRequestQueryString", request.getQueryString());
        this.put("tinyRequestRequestURI", request.getRequestURI());
    }

    @Override
    public WebContext getWrappedWebContext() {
        return this.wrappedContext;
    }

    public WebContext getWrappedWebContext(String contextName) {
        return (WebContext)this.getSubContext(contextName);
    }

    public void putSubWebContext(String contextName, WebContext webContext) {
        this.putContext(contextName, webContext);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        super.put("httpServletContext", (Object)servletContext);
    }

    @Override
    public boolean isRequestFinished() {
        return false;
    }

    @Override
    public void setObject(String scope, String key, Object value) {
        WebContextScope webContextScope = this.scopes.get(scope);
        if (webContextScope != null) {
            webContextScope.setObject(key, value);
            return;
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u8bf7\u6c42\u8303\u56f4", scope));
    }

    @Override
    public Object getObject(String scope, String key) {
        WebContextScope webContextScope = this.scopes.get(scope);
        if (webContextScope != null) {
            return webContextScope.getObject(key);
        }
        throw new RuntimeException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u8bf7\u6c42\u8303\u56f4", scope));
    }

    class HeaderNameVerification
    implements ParamNameVerification {
        HttpServletRequest request;

        HeaderNameVerification(HttpServletRequest request) {
            this.request = request;
        }

        public Object getValue(String name) {
            return this.request.getHeader(name);
        }

        public boolean isExist(String name) {
            Enumeration enumeration = this.request.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    class CookieParamNameVerification
    implements ParamNameVerification {
        HttpServletRequest request;

        CookieParamNameVerification(HttpServletRequest request) {
            this.request = request;
        }

        public Object getValue(String name) {
            if (this.request.getCookies() != null) {
                for (Cookie cookie : this.request.getCookies()) {
                    if (!cookie.getName().equals(name)) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }

        public boolean isExist(String name) {
            if (this.request.getCookies() != null) {
                for (Cookie cookie : this.request.getCookies()) {
                    if (!cookie.getName().equals(name)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class ApplicationAttributeParamNameVerification
    implements ParamNameVerification {
        ServletContext servletContext;

        ApplicationAttributeParamNameVerification(HttpServletRequest request) {
            this.servletContext = request.getSession().getServletContext();
        }

        public Object getValue(String name) {
            return this.servletContext.getAttribute(name);
        }

        public boolean isExist(String name) {
            Enumeration enumeration = this.servletContext.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    class SessionAttributeParamNameVerification
    implements ParamNameVerification {
        HttpSession session;

        SessionAttributeParamNameVerification(HttpServletRequest request) {
            this.session = request.getSession();
        }

        public Object getValue(String name) {
            return this.session.getAttribute(name);
        }

        public boolean isExist(String name) {
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    class RequestParamNameVerification
    implements ParamNameVerification {
        HttpServletRequest request;

        RequestParamNameVerification(HttpServletRequest request) {
            this.request = request;
        }

        public Object getValue(String name) {
            String[] values = this.request.getParameterValues(name);
            if (values != null && values.length == 1) {
                return values[0];
            }
            return values;
        }

        public boolean isExist(String name) {
            Map parameterMap = this.request.getParameterMap();
            return parameterMap.containsKey(name);
        }
    }

    class RequestAttributeParamNameVerification
    implements ParamNameVerification {
        HttpServletRequest request;

        RequestAttributeParamNameVerification(HttpServletRequest request) {
            this.request = request;
        }

        public Object getValue(String name) {
            return this.request.getAttribute(name);
        }

        public boolean isExist(String name) {
            Enumeration enumeration = this.request.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.nextElement().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    class ParamNameVerificationSupport
    implements ParamNameVerification {
        List<ParamNameVerification> verifications = new ArrayList<ParamNameVerification>();

        ParamNameVerificationSupport(HttpServletRequest request) {
            this.verifications.add(new RequestAttributeParamNameVerification(request));
            this.verifications.add(new RequestParamNameVerification(request));
            this.verifications.add(new SessionAttributeParamNameVerification(request));
            this.verifications.add(new CookieParamNameVerification(request));
            this.verifications.add(new HeaderNameVerification(request));
            this.verifications.add(new ApplicationAttributeParamNameVerification(request));
        }

        public Object getValue(String name) {
            for (ParamNameVerification verification : this.verifications) {
                Object value = verification.getValue(name);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public boolean isExist(String name) {
            ParamNameVerification verification;
            boolean exist = false;
            Iterator<ParamNameVerification> i$ = this.verifications.iterator();
            while (i$.hasNext() && !(exist = (verification = i$.next()).isExist(name))) {
            }
            return exist;
        }
    }

    static interface ParamNameVerification {
        public Object getValue(String var1);

        public boolean isExist(String var1);
    }

    class ApplicationScope
    implements WebContextScope {
        private String scope = "applicationScope";

        ApplicationScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getServletContext().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getServletContext().getAttribute(key);
        }
    }

    class SessionScope
    implements WebContextScope {
        private String scope = "sessionScope";

        SessionScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getRequest().getSession().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getRequest().getSession().getAttribute(key);
        }
    }

    class RequestScope
    implements WebContextScope {
        private String scope = "requestScope";

        RequestScope() {
        }

        public String getScope() {
            return this.scope;
        }

        public void setObject(String key, Object value) {
            AbstractWebContextWrapper.this.getRequest().setAttribute(key, value);
        }

        public Object getObject(String key) {
            return AbstractWebContextWrapper.this.getRequest().getAttribute(key);
        }
    }

    static interface WebContextScope {
        public String getScope();

        public void setObject(String var1, Object var2);

        public Object getObject(String var1);
    }
}

