/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.tinygroup.commons.io.ByteArrayInputStream;

public class DeferredByteOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private ByteArrayOutputStream currentOutputStream = this.memoryOutputStream = new ByteArrayOutputStream();
    private boolean closed = false;

    public DeferredByteOutputStream(int threshold) {
        super(threshold);
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        ByteArrayOutputStream totalStream = new ByteArrayOutputStream();
        this.memoryOutputStream.writeTo((OutputStream)totalStream);
        this.currentOutputStream = totalStream;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getMemoryData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public byte[] getFileData() {
        if (this.currentOutputStream != null) {
            return this.currentOutputStream.toByteArray();
        }
        return null;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(out);
        } else {
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(this.currentOutputStream.toByteArray());
            try {
                IOUtils.copy((InputStream)byteInputStream, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)byteInputStream);
            }
        }
    }

    public void clearData() {
        this.memoryOutputStream = null;
        this.currentOutputStream = null;
    }
}

