/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;

public class Flags {
    private final String[] flags;

    public Flags() {
        this(null);
    }

    public Flags(String ... flags) {
        this.flags = flags == null ? BasicConstant.EMPTY_STRING_ARRAY : flags;
    }

    public boolean isEmpty() {
        return ArrayUtil.isEmptyArray((Object)this.flags);
    }

    protected String[] getFlags() {
        return this.flags;
    }

    protected boolean hasFlags(String ... names) {
        Assert.assertTrue((!ArrayUtil.isEmptyArray((Object)names) ? 1 : 0) != 0, (String)"names", (Object[])new Object[0]);
        for (String flag : this.flags) {
            for (String name : names) {
                if (!flag.startsWith(name) || flag.length() != name.length() && flag.charAt(name.length()) != '=') continue;
                return true;
            }
        }
        return false;
    }

    protected String getFlagValue(String ... names) {
        Assert.assertTrue((!ArrayUtil.isEmptyArray((Object)names) ? 1 : 0) != 0, (String)"names", (Object[])new Object[0]);
        for (String flag : this.flags) {
            for (String name : names) {
                if (!flag.startsWith(name)) continue;
                if (flag.length() == name.length()) {
                    return "";
                }
                if (flag.charAt(name.length()) != '=') continue;
                return StringUtil.trimToEmpty((String)flag.substring(name.length() + 1));
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder.CollectionBuilder().setOneLine(true).appendAll((Object[])this.flags).toString();
    }
}

