/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.MatchResultSubstitution;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteCondition;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitution;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionHandler;

public class RewriteRule
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RewriteRule.class);
    private String patternString;
    private Pattern pattern;
    private boolean negative;
    private RewriteCondition[] conditions;
    private RewriteSubstitution substitution;
    private Object[] handlers;

    public String getPattern() {
        return this.patternString;
    }

    public void setPattern(String patternString) throws PatternSyntaxException {
        this.patternString = StringUtil.trimToNull((String)patternString);
    }

    public void setConditions(RewriteCondition[] conditions) {
        this.conditions = conditions;
    }

    public void setSubstitution(RewriteSubstitution substitution) {
        this.substitution = substitution;
    }

    public void setHandlers(Object[] handlers) {
        this.handlers = handlers;
    }

    public Object[] handlers() {
        return this.handlers;
    }

    public void afterPropertiesSet() throws Exception {
        String realPattern;
        if (this.patternString == null || "!".equals(this.patternString)) {
            throw new PatternSyntaxException("empty pattern", this.patternString, -1);
        }
        if (this.patternString.startsWith("!")) {
            this.negative = true;
            realPattern = this.patternString.substring(1);
        } else {
            realPattern = this.patternString;
        }
        this.pattern = Pattern.compile(realPattern);
        if (this.conditions == null) {
            this.conditions = new RewriteCondition[0];
        }
        for (RewriteCondition condition : this.conditions) {
            condition.afterPropertiesSet();
        }
        if (this.substitution == null) {
            this.substitution = new RewriteSubstitution();
        }
        this.substitution.afterPropertiesSet();
        if (this.handlers == null) {
            this.handlers = new RewriteSubstitutionHandler[0];
        }
    }

    public MatchResult match(String path) {
        Matcher matcher = this.pattern.matcher(path);
        boolean matched = matcher.find();
        if (!this.negative && matched) {
            logger.logMessage(LogLevel.DEBUG, "Testing \"{}\" with rule pattern: \"{}\", MATCHED", new Object[]{StringEscapeUtil.escapeJava((String)path), StringEscapeUtil.escapeJava((String)this.patternString)});
            return matcher.toMatchResult();
        }
        if (this.negative && !matched) {
            logger.logMessage(LogLevel.DEBUG, "Testing \"{}\" with rule pattern: \"{}\", MATCHED", new Object[]{StringEscapeUtil.escapeJava((String)path), StringEscapeUtil.escapeJava((String)this.patternString)});
            return MatchResultSubstitution.EMPTY_MATCH_RESULT;
        }
        logger.logMessage(LogLevel.TRACE, "Testing \"{}\" with rule pattern: \"{}\", MISMATCHED", new Object[]{StringEscapeUtil.escapeJava((String)path), StringEscapeUtil.escapeJava((String)this.patternString)});
        return null;
    }

    public MatchResult matchConditions(MatchResult ruleMatchResult, HttpServletRequest request) {
        MatchResult conditionMatchResult = MatchResultSubstitution.EMPTY_MATCH_RESULT;
        if (!ArrayUtil.isEmptyArray((Object)this.conditions)) {
            int i = 0;
            for (RewriteCondition condition : this.conditions) {
                boolean ornext;
                MatchResult result = condition.match(ruleMatchResult, conditionMatchResult, request);
                boolean bl = ornext = i < this.conditions.length - 1 && condition.getConditionFlags().hasOR();
                if (result == null) {
                    if (!ornext) {
                        conditionMatchResult = null;
                        break;
                    }
                } else {
                    conditionMatchResult = result;
                    if (ornext) break;
                }
                ++i;
            }
        }
        return conditionMatchResult;
    }

    public RewriteSubstitution getSubstitution() {
        return this.substitution;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("pattern", (Object)this.patternString);
        if (!ArrayUtil.isEmptyArray((Object)this.conditions)) {
            mb.append("conditions", (Object)this.conditions);
        }
        mb.append("substitution", (Object)this.substitution);
        return new ToStringBuilder().append((Object)"RewriteRule").append((Object)mb).toString();
    }
}

