/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite.impl;

import java.io.IOException;
import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.FileUtil;
import org.tinygroup.commons.tools.MatchResultSubstitution;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractRequestWrapper;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ParameterParser;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteRule;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitution;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionContext;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionHandler;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteUtil;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteWebContext;
import org.tinygroup.weblayer.webcontext.util.ServletUtil;
import org.tinygroup.weblayer.webcontext.util.WebContextUtil;

public class RewriteWebContextImpl
extends AbstractWebContextWrapper
implements RewriteWebContext {
    private static final Logger logger = LoggerFactory.getLogger(RewriteWebContext.class);
    public static final String SERVER_SCHEME_HTTP = "http";
    public static final String SERVER_SCHEME_HTTPS = "https";
    public static final int SERVER_PORT_HTTP = 80;
    public static final int SERVER_PORT_HTTPS = 443;
    private final RewriteRule[] rules;
    private ParserWebContext parserWebContext;
    private HttpServletRequest wrappedRequest;
    private RequestWrapper requestWrapper;

    public RewriteWebContextImpl(WebContext wrappedContext, RewriteRule[] rules) {
        super(wrappedContext);
        this.rules = (RewriteRule[])ArrayUtil.defaultIfEmptyArray((Object)rules, null);
        this.parserWebContext = (ParserWebContext)Assert.assertNotNull((Object)WebContextUtil.findWebContext(wrappedContext, ParserWebContext.class), (String)"Could not find ParserRequestContext in request context chain", (Object[])new Object[0]);
        this.wrappedRequest = wrappedContext.getRequest();
        this.requestWrapper = new RequestWrapper(this.wrappedRequest);
        this.setRequest((HttpServletRequest)this.requestWrapper);
    }

    public void prepare() {
        block16: {
            String originalPath;
            if (this.rules == null) {
                return;
            }
            String path = originalPath = this.wrappedRequest.getServletPath() + (String)ObjectUtil.defaultIfNull((Object)this.wrappedRequest.getPathInfo(), (Object)"");
            boolean parameterSubstituted = false;
            logger.logMessage(LogLevel.DEBUG, "Starting rewrite engine: path=\"{}\"", new Object[]{StringEscapeUtil.escapeJava((String)path)});
            int redirectCode = 0;
            for (RewriteRule rule : this.rules) {
                MatchResult ruleMatchResult = rule.match(path);
                MatchResult conditionMatchResult = null;
                RewriteSubstitution subs = rule.getSubstitution();
                if (ruleMatchResult != null) {
                    conditionMatchResult = rule.matchConditions(ruleMatchResult, this.wrappedRequest);
                }
                boolean chainRule = subs.getSubFlags().hasC();
                if (conditionMatchResult == null) {
                    if (!chainRule) continue;
                    break;
                }
                MatchResultSubstitution resultSubs = RewriteUtil.getMatchResultSubstitution(ruleMatchResult, conditionMatchResult);
                logger.logMessage(LogLevel.DEBUG, "Rule conditions have been satisfied, starting substitution to uri");
                path = subs.substitute(path, resultSubs);
                if (!RewriteUtil.isFullURL(path)) {
                    path = FileUtil.normalizeAbsolutePath((String)path);
                }
                parameterSubstituted |= subs.substituteParameters(this.parserWebContext.getParameters(), resultSubs);
                path = this.firePostSubstitutionEvent(rule, path, this.parserWebContext, resultSubs);
                redirectCode = subs.getSubFlags().getRedirectCode();
                boolean lastRule = subs.getSubFlags().hasL();
                if (lastRule) break;
            }
            if (!ObjectUtil.isEquals((Object)originalPath, (Object)path)) {
                if (redirectCode > 0) {
                    StringBuffer uri = new StringBuffer();
                    HttpServletRequest request = this.getRequest();
                    if (!RewriteUtil.isFullURL(path)) {
                        uri.append(request.getScheme()).append("://").append(request.getServerName());
                        boolean isDefaultPort = false;
                        isDefaultPort |= SERVER_SCHEME_HTTP.equals(request.getScheme()) && request.getServerPort() == 80;
                        if (!(isDefaultPort |= SERVER_SCHEME_HTTPS.equals(request.getScheme()) && request.getServerPort() == 443)) {
                            uri.append(":");
                            uri.append(request.getServerPort());
                        }
                        uri.append(request.getContextPath());
                    }
                    uri.append(path);
                    String queryString = this.parserWebContext.getParameters().toQueryString();
                    if (!StringUtil.isEmpty((String)queryString)) {
                        uri.append("?").append(queryString);
                    }
                    String uriLocation = uri.toString();
                    try {
                        if (redirectCode == 302) {
                            this.getResponse().sendRedirect(uriLocation);
                            break block16;
                        }
                        this.getResponse().setHeader("Location", uriLocation);
                        this.getResponse().setStatus(redirectCode);
                    }
                    catch (IOException e) {
                        logger.logMessage(LogLevel.WARN, "Redirect to location \"" + uriLocation + "\" failed", (Throwable)e);
                    }
                } else {
                    this.requestWrapper.setPath(path);
                }
            } else if (!parameterSubstituted) {
                logger.logMessage(LogLevel.TRACE, "No rewrite substitution happend!");
            }
        }
    }

    private String firePostSubstitutionEvent(RewriteRule rule, String path, ParserWebContext parser, MatchResultSubstitution resultSubs) {
        for (Object handler : rule.handlers()) {
            RewriteSubstitutionContextImpl context = null;
            if (!(handler instanceof RewriteSubstitutionHandler)) continue;
            if (context == null) {
                context = new RewriteSubstitutionContextImpl(path, parser, resultSubs);
            }
            logger.logMessage(LogLevel.TRACE, "Processing post-substitution event for \"{}\" with handler: {}", new Object[]{StringEscapeUtil.escapeJava((String)path), handler});
            ((RewriteSubstitutionHandler)handler).postSubstitution(context);
            String newPath = context.getPath();
            if (newPath != null && !ObjectUtil.isEquals((Object)path, (Object)newPath)) {
                logger.logMessage(LogLevel.DEBUG, "Rewriting \"{}\" to \"{}\"", new Object[]{StringEscapeUtil.escapeJava((String)path), StringEscapeUtil.escapeJava((String)newPath)});
            }
            path = newPath;
        }
        return path;
    }

    public void setPath(String path) {
        this.requestWrapper.setPath(path);
    }

    private class RequestWrapper
    extends AbstractRequestWrapper {
        private String path;
        private final boolean prefixMapping;
        private final String originalServletPath;

        public RequestWrapper(HttpServletRequest request) {
            super(RewriteWebContextImpl.this, request);
            this.prefixMapping = ServletUtil.isPrefixServletMapping(request);
            this.originalServletPath = request.getServletPath();
        }

        public void setPath(String path) {
            this.path = StringUtil.trimToNull((String)path);
        }

        public String getServletPath() {
            if (this.path == null) {
                return super.getServletPath();
            }
            if (this.prefixMapping) {
                if (ServletUtil.startsWithPath(this.originalServletPath, this.path)) {
                    return this.originalServletPath;
                }
                return "";
            }
            return this.path;
        }

        public String getPathInfo() {
            if (this.path == null) {
                return super.getPathInfo();
            }
            if (this.prefixMapping) {
                if (ServletUtil.startsWithPath(this.originalServletPath, this.path)) {
                    return this.path.substring(this.originalServletPath.length());
                }
                return this.path;
            }
            return null;
        }
    }

    private class RewriteSubstitutionContextImpl
    implements RewriteSubstitutionContext {
        private String path;
        private ParserWebContext parser;
        private MatchResultSubstitution resultSubs;

        public RewriteSubstitutionContextImpl(String path, ParserWebContext parser, MatchResultSubstitution resultSubs) {
            this.path = path;
            this.parser = parser;
            this.resultSubs = resultSubs;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public ParserWebContext getParserWebContext() {
            return this.parser;
        }

        public ParameterParser getParameters() {
            return this.parser.getParameters();
        }

        public MatchResultSubstitution getMatchResultSubstitution() {
            return this.resultSubs;
        }
    }
}

