/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.webcontext.session.ExactMatchesOnlySessionStore;
import org.tinygroup.weblayer.webcontext.session.SessionConfig;
import org.tinygroup.weblayer.webcontext.session.SessionIDGenerator;
import org.tinygroup.weblayer.webcontext.session.SessionInterceptor;
import org.tinygroup.weblayer.webcontext.session.SessionModelEncoder;
import org.tinygroup.weblayer.webcontext.session.SessionStore;
import org.tinygroup.weblayer.webcontext.session.exception.SessionFrameworkException;
import org.tinygroup.weblayer.webcontext.session.impl.SessionModelEncoderImpl;
import org.tinygroup.weblayer.webcontext.session.impl.UUIDGenerator;
import org.tinygroup.xmlparser.node.XmlNode;

public class SessionConfiguration
extends AbstractConfiguration {
    private static final String SESSION_CONFIG = "/application/session";
    private static final String BEAN_NAME = "bean-name";
    private static XmlNode sessionNode;
    private ConfigImpl config = new ConfigImpl();

    public String getApplicationNodePath() {
        return SESSION_CONFIG;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
        if (applicationConfig != null) {
            sessionNode = applicationConfig;
            try {
                this.config.init();
            }
            catch (Exception e) {
                throw new SessionFrameworkException(e.getMessage(), e);
            }
            String storeName = this.config.getStoreMappings().getStoreNameForAttribute(this.config.getModelKey());
            if (storeName == null) {
                throw new IllegalArgumentException("No storage configured for session model: key=" + this.config.getModelKey());
            }
        }
    }

    public ConfigImpl getSessionConfig() {
        return this.config;
    }

    public static class AttributePattern {
        public final String patternName;
        public final String storeName;
        public final Pattern pattern;

        public static AttributePattern getDefaultPattern(String storeName) {
            return new AttributePattern(storeName, null, null);
        }

        public static AttributePattern getExactPattern(String storeName, String attrName) {
            return new AttributePattern(storeName, attrName, null);
        }

        public static AttributePattern getRegexPattern(String storeName, String regexName) {
            try {
                return new AttributePattern(storeName, regexName, Pattern.compile(regexName));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid regex pattern %s for store %s", regexName, storeName));
            }
        }

        private AttributePattern(String storeName, String patternName, Pattern pattern) {
            this.storeName = (String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)storeName), (String)"storeName", (Object[])new Object[0]);
            this.patternName = patternName;
            this.pattern = pattern;
        }

        public boolean isDefaultPattern() {
            return this.patternName == null;
        }

        public boolean isRegexPattern() {
            return this.pattern != null;
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            ToStringBuilder buf = new ToStringBuilder();
            if (this.isDefaultPattern()) {
                buf.format("match=\"*\", store=\"%s\"", new Object[]{this.storeName});
            } else if (this.isRegexPattern()) {
                buf.format("match=~/%s/, store=\"%s\"", new Object[]{this.patternName, this.storeName});
            } else {
                buf.format("match=\"%s\", store=\"%s\"", new Object[]{this.patternName, this.storeName});
            }
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeMatch
    implements Comparable<AttributeMatch> {
        private final AttributePattern pattern;
        private final int matchLength;

        public AttributeMatch(AttributePattern pattern, int matchLength) {
            this.pattern = pattern;
            this.matchLength = matchLength;
        }

        @Override
        public int compareTo(AttributeMatch o) {
            int result = o.matchLength - this.matchLength;
            if (result == 0) {
                int r1 = this.pattern.isRegexPattern() ? 0 : 1;
                int r2 = o.pattern.isRegexPattern() ? 0 : 1;
                return r2 - r1;
            }
            return result;
        }

        public String toString() {
            return new ToStringBuilder().append((Object)this.pattern).append((Object)", matchLength=").append(this.matchLength).toString();
        }
    }

    private static class StoreMappingsConfigImpl
    implements SessionConfig.StoreMappingsConfig {
        private static final String MATCH_ALL = "*";
        private static final String MATCH_CONFIG_NAME = "match";
        private static final String NAME = "name";
        private static final String STORE = "store";
        private static final String PATTERN = "pattern";
        private static final String MATCH_REGEX_NODE_NAME = "matchRegex";
        private AttributePattern[] patterns;
        private String defaultStore;
        private Map<String, String> attributeMatchCache;

        private StoreMappingsConfigImpl() {
        }

        public void setPatterns(AttributePattern[] patterns) {
            this.patterns = patterns;
        }

        private void init(SessionConfig.StoresConfig stores) {
            this.attributeMatchCache = CollectionUtil.createConcurrentHashMap();
            if (this.patterns == null) {
                this.patterns = this.parserMatchConfig();
                this.patterns = (AttributePattern[])ObjectUtil.defaultIfNull((Object)this.patterns, (Object)new AttributePattern[0]);
            }
            for (AttributePattern pattern : this.patterns) {
                if (pattern.isDefaultPattern()) {
                    if (this.defaultStore != null) {
                        throw new IllegalArgumentException("More than one stores mapped to *: " + this.defaultStore + " and " + pattern.getStoreName());
                    }
                    this.defaultStore = pattern.getStoreName();
                }
                if (stores.getStore(pattern.getStoreName()) != null) continue;
                throw new IllegalArgumentException("Undefined Session Store: " + pattern);
            }
        }

        private AttributePattern[] parserMatchConfig() {
            List matchNodes;
            Assert.assertNotNull((Object)sessionNode, (String)"\u89e3\u6790\u7684\u8282\u70b9\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            NameFilter matchFilter = new NameFilter((Node)sessionNode);
            List matchRegexNodes = matchFilter.findNodeList(MATCH_REGEX_NODE_NAME);
            ArrayList<AttributePattern> patterns = new ArrayList<AttributePattern>();
            if (!CollectionUtil.isEmpty((Collection)matchRegexNodes)) {
                for (int i = 0; i < matchRegexNodes.size(); ++i) {
                    String patternName = ((XmlNode)matchRegexNodes.get(i)).getAttribute(PATTERN);
                    String storeName = ((XmlNode)matchRegexNodes.get(i)).getAttribute(STORE);
                    patterns.add(AttributePattern.getRegexPattern(storeName, patternName));
                }
            }
            if (!CollectionUtil.isEmpty((Collection)(matchNodes = matchFilter.findNodeList(MATCH_CONFIG_NAME)))) {
                for (XmlNode xmlNode : matchNodes) {
                    String name = xmlNode.getAttribute(NAME);
                    String storeName = xmlNode.getAttribute(STORE);
                    if (MATCH_ALL.equals(name)) {
                        patterns.add(AttributePattern.getDefaultPattern(storeName));
                        continue;
                    }
                    patterns.add(AttributePattern.getExactPattern(storeName, name));
                }
            }
            return patterns.toArray(new AttributePattern[0]);
        }

        public String getStoreNameForAttribute(String attrName) {
            String matchedStoreName = this.attributeMatchCache.get(attrName = (String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)attrName), (String)"attrName must not null", (Object[])new Object[0]));
            if (matchedStoreName != null) {
                return matchedStoreName;
            }
            ArrayList matches = CollectionUtil.createArrayList((int)this.patterns.length);
            for (AttributePattern pattern : this.patterns) {
                if (pattern.isDefaultPattern()) {
                    matches.add(new AttributeMatch(pattern, 0));
                    continue;
                }
                if (pattern.isRegexPattern()) {
                    Matcher matcher = pattern.getPattern().matcher(attrName);
                    if (!matcher.find()) continue;
                    matches.add(new AttributeMatch(pattern, matcher.end() - matcher.start()));
                    continue;
                }
                if (!pattern.patternName.equals(attrName)) continue;
                matches.add(new AttributeMatch(pattern, pattern.patternName.length()));
            }
            Collections.sort(matches);
            ToStringBuilder buf = new ToStringBuilder();
            if (matches.isEmpty()) {
                buf.append((Object)"does not match any pattern");
            } else {
                buf.append((Object)"matches the following CANDIDATED patterns:").append((Object)matches);
            }
            buf.format("Attribute \"%s\" ", new Object[]{attrName});
            LOGGER.logMessage(LogLevel.DEBUG, buf.toString());
            if (!matches.isEmpty()) {
                matchedStoreName = ((AttributeMatch)matches.get(0)).pattern.getStoreName();
            }
            if (matchedStoreName != null) {
                this.attributeMatchCache.put(attrName, matchedStoreName);
            }
            if (matchedStoreName != null) {
                LOGGER.logMessage(LogLevel.DEBUG, "Session attribute {} is handled by session store: {}", new Object[]{attrName, matchedStoreName});
            }
            return matchedStoreName;
        }

        public String[] getExactMatchedAttributeNames(String storeName) {
            storeName = (String)Assert.assertNotNull((Object)StringUtil.trimToNull((String)storeName), (String)"no storeName", (Object[])new Object[0]);
            LinkedHashSet attrNames = CollectionUtil.createLinkedHashSet();
            for (AttributePattern pattern : this.patterns) {
                if (!pattern.getStoreName().equals(storeName)) continue;
                if (pattern.isDefaultPattern() || pattern.isRegexPattern()) {
                    return null;
                }
                attrNames.add(pattern.patternName);
            }
            return attrNames.toArray(new String[attrNames.size()]);
        }

        public String toString() {
            return new ToStringBuilder().append((Object)"StoreMappings").append((Object)this.patterns).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StoresConfigImpl
    implements SessionConfig.StoresConfig {
        private static final String ATTRIBUTE_NAME = "bean-name";
        private static final String SESSION_STORE_CONFIG_NAME = "session-store";
        private Map<String, SessionStore> stores;

        private StoresConfigImpl() {
        }

        public void setStores(LinkedHashMap<String, SessionStore> stores) {
            this.stores = stores;
        }

        @Override
        public SessionStore getStore(String storeName) {
            return this.stores.get(storeName);
        }

        @Override
        public String[] getStoreNames() {
            return this.stores.keySet().toArray(new String[this.stores.size()]);
        }

        private void init(SessionConfig sessionConfig) throws Exception {
            List sessionStoreNodes;
            XmlNode storesNode;
            if (this.stores == null && (storesNode = (XmlNode)sessionNode.getSubNode("stores")) != null && !CollectionUtil.isEmpty((Collection)(sessionStoreNodes = storesNode.getSubNodes(SESSION_STORE_CONFIG_NAME)))) {
                this.stores = new HashMap<String, SessionStore>();
                for (XmlNode storeNode : sessionStoreNodes) {
                    String beanName = storeNode.getAttribute("bean-name");
                    SessionStore sessionStore = (SessionStore)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
                    this.stores.put(beanName, sessionStore);
                }
            }
            for (Map.Entry<String, SessionStore> entry : this.stores.entrySet()) {
                entry.getValue().init(entry.getKey(), sessionConfig);
            }
        }

        public String toString() {
            return new ToStringBuilder().append((Object)"Stores").append(this.stores).toString();
        }
    }

    private static class UrlEncodeConfigImpl
    implements SessionConfig.UrlEncodeConfig {
        private static final String URL_ENCODE_CONFIG_NAME = "url-encode";
        private static final String NAME = "name";
        private String name;

        private UrlEncodeConfigImpl() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        private void init(XmlNode idNode) {
            if (this.name == null) {
                XmlNode urlEncodeNode = (XmlNode)idNode.getSubNode(URL_ENCODE_CONFIG_NAME);
                this.name = StringUtil.defaultIfEmpty((String)urlEncodeNode.getAttribute(NAME), (String)"JSESSIONID");
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append(NAME, (Object)this.name);
            return new ToStringBuilder().append((Object)"UrlEncodeConfig").append((Object)mb).toString();
        }
    }

    private static class CookieConfigImpl
    implements SessionConfig.CookieConfig {
        private static final String COOKIE_CONFIG_NAME = "cookie";
        private static final String NAME = "name";
        private static final String DOMAIN = "domain";
        private static final String PATH = "path";
        private static final String MAX_AGE = "maxAge";
        private static final String HTTP_ONLY = "httpOnly";
        private static final String SECURE = "secure";
        private String name;
        private String domain;
        private String path;
        private Integer maxAge;
        private Boolean httpOnly;
        private Boolean secure;

        private CookieConfigImpl() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            if ((domain = StringUtil.trimToNull((String)domain)) != null && !domain.startsWith(".")) {
                domain = "." + domain;
            }
            this.domain = domain;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        private void init(XmlNode idNode) {
            XmlNode cookieNode = (XmlNode)idNode.getSubNode(COOKIE_CONFIG_NAME);
            if (this.name == null) {
                this.name = StringUtil.defaultIfEmpty((String)cookieNode.getAttribute(NAME), (String)"JSESSIONID");
            }
            if (this.domain == null) {
                this.domain = StringUtil.defaultIfEmpty((String)cookieNode.getAttribute(DOMAIN), (String)COOKIE_DOMAIN_DEFAULT);
            }
            if (this.path == null) {
                this.path = StringUtil.defaultIfEmpty((String)cookieNode.getAttribute(PATH), (String)"/");
            }
            if (this.maxAge == null) {
                String maxAgeString = cookieNode.getAttribute(MAX_AGE);
                this.maxAge = maxAgeString == null ? COOKIE_MAX_AGE_DEFAULT : Integer.valueOf(Integer.parseInt(maxAgeString));
            }
            if (this.httpOnly == null) {
                String httpOnlyString = cookieNode.getAttribute(HTTP_ONLY);
                this.httpOnly = httpOnlyString == null ? COOKIE_HTTP_ONLY_DEFAULT : Boolean.valueOf(Boolean.parseBoolean(httpOnlyString));
            }
            if (this.secure == null) {
                String secureString = cookieNode.getAttribute(SECURE);
                this.secure = secureString == null ? COOKIE_SECURE_DEFAULT : Boolean.valueOf(Boolean.parseBoolean(secureString));
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append(NAME, (Object)this.name);
            mb.append(DOMAIN, (Object)this.domain);
            mb.append(PATH, (Object)this.path);
            mb.append(MAX_AGE, (Object)String.format("%,d seconds", this.maxAge));
            mb.append(HTTP_ONLY, (Object)this.httpOnly);
            mb.append(SECURE, (Object)this.secure);
            return new ToStringBuilder().append((Object)"CookieConfig").append((Object)mb).toString();
        }
    }

    private static class IdConfigImpl
    implements SessionConfig.IdConfig {
        private static final String SESSIONID_GENERATOR = "sessionid-generator";
        private static final String COOKIE_ENABLED = "cookieEnabled";
        private static final String ID_CONFIG_NODE_NAME = "id";
        private static final String URL_ENCODE_ENABLED = "urlEncodeEnabled";
        private final CookieConfigImpl cookie = new CookieConfigImpl();
        private final UrlEncodeConfigImpl urlEncode = new UrlEncodeConfigImpl();
        private Boolean cookieEnabled;
        private Boolean urlEncodeEnabled;
        private SessionIDGenerator generator;

        private IdConfigImpl() {
        }

        public boolean isCookieEnabled() {
            return this.cookieEnabled;
        }

        public void setCookieEnabled(boolean cookieEnabled) {
            this.cookieEnabled = cookieEnabled;
        }

        public boolean isUrlEncodeEnabled() {
            return this.urlEncodeEnabled;
        }

        public void setUrlEncodeEnabled(boolean urlEncodeEnabled) {
            this.urlEncodeEnabled = urlEncodeEnabled;
        }

        public SessionConfig.CookieConfig getCookie() {
            return this.cookie;
        }

        public SessionConfig.UrlEncodeConfig getUrlEncode() {
            return this.urlEncode;
        }

        public SessionIDGenerator getGenerator() {
            return this.generator;
        }

        public void setGenerator(SessionIDGenerator generator) {
            this.generator = generator;
        }

        private void init() {
            String enabled;
            XmlNode idNode = (XmlNode)sessionNode.getSubNode(ID_CONFIG_NODE_NAME);
            if (this.cookieEnabled == null) {
                enabled = idNode.getAttribute(COOKIE_ENABLED);
                this.cookieEnabled = enabled == null ? COOKIE_ENABLED_DEFAULT : Boolean.valueOf(Boolean.parseBoolean(enabled));
            }
            if (this.urlEncodeEnabled == null) {
                enabled = idNode.getAttribute(URL_ENCODE_ENABLED);
                this.urlEncodeEnabled = enabled == null ? URL_ENCODE_ENABLED_DEFAULT : Boolean.valueOf(Boolean.parseBoolean(enabled));
            }
            if (this.generator == null) {
                XmlNode idGenNode = (XmlNode)idNode.getSubNode(SESSIONID_GENERATOR);
                String beanName = idGenNode.getAttribute(SessionConfiguration.BEAN_NAME);
                this.generator = !StringUtil.isBlank((String)beanName) ? (SessionIDGenerator)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName) : new UUIDGenerator();
            }
            this.cookie.init(idNode);
            this.urlEncode.init(idNode);
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append(COOKIE_ENABLED, (Object)this.cookieEnabled);
            mb.append(URL_ENCODE_ENABLED, (Object)this.urlEncodeEnabled);
            mb.append("cookieConfig", (Object)this.cookie);
            mb.append("urlEncodeConfig", (Object)this.urlEncode);
            mb.append("generator", (Object)this.generator);
            return new ToStringBuilder().append((Object)"IdConfig").append((Object)mb).toString();
        }
    }

    public static class ConfigImpl
    implements SessionConfig {
        private static final String LIFECYCLE_LOGGER = "lifecycle-logger";
        private static final String INTERCEPTORS = "interceptors";
        private static final String INTERCEPTOR = "interceptor";
        private static final String MAX_INACTIVE_INTERVAL = "maxInactiveInterval";
        private static final String FORCE_EXPIRATION_PERIOD = "forceExpirationPeriod";
        private static final String MODEL_KEY = "modelKey";
        private static final String KEEP_IN_TOUCH = "keepInTouch";
        private static final String SESSION_MODEL_ENCODERS = "session-model-encoders";
        private static final String SESSION_MODEL_ENCODER = "session-model-encoder";
        private final IdConfigImpl id = new IdConfigImpl();
        private final StoresConfigImpl stores = new StoresConfigImpl();
        private final StoreMappingsConfigImpl storeMappings = new StoreMappingsConfigImpl();
        private Integer maxInactiveInterval;
        private Long forceExpirationPeriod;
        private String modelKey;
        private Boolean keepInTouch;
        private SessionModelEncoder[] sessionModelEncoders;
        private SessionInterceptor[] sessionInterceptors;

        public int getMaxInactiveInterval() {
            return this.maxInactiveInterval;
        }

        public void setMaxInactiveInterval(int maxInactiveInterval) {
            this.maxInactiveInterval = maxInactiveInterval;
        }

        public long getForceExpirationPeriod() {
            return this.forceExpirationPeriod;
        }

        public void setForceExpirationPeriod(long forceExpirationPeriod) {
            this.forceExpirationPeriod = forceExpirationPeriod;
        }

        public String getModelKey() {
            return this.modelKey;
        }

        public void setModelKey(String modelKey) {
            this.modelKey = modelKey;
        }

        public boolean isKeepInTouch() {
            return this.keepInTouch;
        }

        public void setKeepInTouch(boolean keepInTouch) {
            this.keepInTouch = keepInTouch;
        }

        public SessionConfig.IdConfig getId() {
            return this.id;
        }

        public SessionConfig.StoresConfig getStores() {
            return this.stores;
        }

        public SessionConfig.StoreMappingsConfig getStoreMappings() {
            return this.storeMappings;
        }

        public SessionModelEncoder[] getSessionModelEncoders() {
            return this.sessionModelEncoders;
        }

        public void setSessionModelEncoders(SessionModelEncoder[] sessionModelEncoders) {
            this.sessionModelEncoders = sessionModelEncoders;
        }

        public SessionInterceptor[] getSessionInterceptors() {
            return this.sessionInterceptors;
        }

        public void setSessionInterceptors(SessionInterceptor[] sessionInterceptors) {
            this.sessionInterceptors = sessionInterceptors;
        }

        public void init() throws Exception {
            List xmlNodes;
            XmlNode interceptorNodes;
            List encoderNodes;
            if (this.maxInactiveInterval == null) {
                String interval = sessionNode.getAttribute(MAX_INACTIVE_INTERVAL);
                this.maxInactiveInterval = interval == null ? MAX_INACTIVE_INTERVAL_DEFAULT : Integer.valueOf(Integer.parseInt(interval));
            }
            if (this.forceExpirationPeriod == null) {
                String period = sessionNode.getAttribute(FORCE_EXPIRATION_PERIOD);
                this.forceExpirationPeriod = period == null ? FORCE_EXPIRATION_PERIOD_DEFAULT : Long.valueOf(Long.parseLong(period));
            }
            if (this.modelKey == null) {
                this.modelKey = StringUtil.defaultIfEmpty((String)sessionNode.getAttribute(MODEL_KEY), (String)"SESSION_MODEL");
            }
            if (this.keepInTouch == null) {
                String touch = sessionNode.getAttribute(KEEP_IN_TOUCH);
                this.keepInTouch = touch == null ? KEEP_IN_TOUCH_DEFAULT : Boolean.valueOf(Boolean.parseBoolean(touch));
            }
            this.id.init();
            this.stores.init(this);
            this.storeMappings.init(this.stores);
            for (String storeName : this.stores.getStoreNames()) {
                SessionStore store = this.stores.getStore(storeName);
                if (!(store instanceof ExactMatchesOnlySessionStore)) continue;
                String[] exactMatchedAttrNames = this.storeMappings.getExactMatchedAttributeNames(storeName);
                if (exactMatchedAttrNames == null) {
                    throw new IllegalArgumentException("Session store " + storeName + " only support exact matches to attribute names");
                }
                ((ExactMatchesOnlySessionStore)store).initAttributeNames(exactMatchedAttrNames);
            }
            XmlNode modelEncodersNode = (XmlNode)sessionNode.getSubNode(SESSION_MODEL_ENCODERS);
            if (modelEncodersNode != null && !CollectionUtil.isEmpty((Collection)(encoderNodes = modelEncodersNode.getSubNodes(SESSION_MODEL_ENCODER)))) {
                this.sessionModelEncoders = new SessionModelEncoder[encoderNodes.size()];
                for (int i = 0; i < encoderNodes.size(); ++i) {
                    XmlNode encoderNode = (XmlNode)encoderNodes.get(i);
                    String beanName = encoderNode.getAttribute(SessionConfiguration.BEAN_NAME);
                    if (StringUtil.isBlank((String)beanName)) continue;
                    this.sessionModelEncoders[i] = (SessionModelEncoder)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
                }
            }
            if (ArrayUtil.isEmptyArray((Object)this.sessionModelEncoders)) {
                this.sessionModelEncoders = new SessionModelEncoder[]{new SessionModelEncoderImpl()};
            }
            if ((interceptorNodes = (XmlNode)sessionNode.getSubNode(INTERCEPTORS)) != null && !CollectionUtil.isEmpty((Collection)(xmlNodes = interceptorNodes.getSubNodes(INTERCEPTOR)))) {
                this.sessionInterceptors = new SessionInterceptor[xmlNodes.size()];
                for (int i = 0; i < xmlNodes.size(); ++i) {
                    XmlNode xmlNode = (XmlNode)xmlNodes.get(i);
                    String beanName = xmlNode.getAttribute(SessionConfiguration.BEAN_NAME);
                    if (StringUtil.isBlank((String)beanName)) continue;
                    this.sessionInterceptors[i] = (SessionInterceptor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(beanName);
                }
            }
            if (ArrayUtil.isEmptyArray((Object)this.sessionInterceptors)) {
                this.sessionInterceptors = new SessionInterceptor[0];
            }
            for (SessionInterceptor l : this.sessionInterceptors) {
                l.init(this);
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append(MAX_INACTIVE_INTERVAL, (Object)String.format("%,d seconds (%,3.2f hours)", this.maxInactiveInterval, (double)this.maxInactiveInterval.intValue() / 3600.0));
            mb.append(FORCE_EXPIRATION_PERIOD, (Object)String.format("%,d seconds (%,3.2f hours)", this.forceExpirationPeriod, (double)this.forceExpirationPeriod.longValue() / 3600.0));
            mb.append(MODEL_KEY, (Object)this.modelKey);
            mb.append(KEEP_IN_TOUCH, (Object)this.keepInTouch);
            mb.append("idConfig", (Object)this.id);
            mb.append("stores", (Object)this.stores);
            mb.append("storeMappings", (Object)this.storeMappings);
            mb.append("sessionModelEncoders", (Object)this.sessionModelEncoders);
            return new ToStringBuilder().append((Object)"SessionConfig").append((Object)mb).toString();
        }
    }
}

