/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.application.impl.ApplicationDefault;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.fileresolver.impl.ConfigurationFileProcessor;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.springutil.SpringBeanContainer;
import org.tinygroup.springutil.fileresolver.SpringBeansFileProcessor;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManager;
import org.tinygroup.weblayer.configmanager.TinyListenerConfigManagerHolder;
import org.tinygroup.weblayer.listener.ServletContextHolder;
import org.tinygroup.weblayer.listener.TinyServletContext;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ApplicationStartupListener
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ApplicationStartupListener.class);
    private Application application = null;

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u4e2d...");
        this.application.stop();
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u505c\u6b62\u5b8c\u6210\u3002");
        this.destroyContextListener(servletContextEvent);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        TinyServletContext servletContext = new TinyServletContext(servletContextEvent.getServletContext());
        ServletContextHolder.setServletContext(servletContext);
        Enumeration enumeration = servletContextEvent.getServletContext().getAttributeNames();
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u5f00\u59cb");
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            logger.logMessage(LogLevel.INFO, "{0}=[{1}]", new Object[]{key, servletContextEvent.getServletContext().getAttribute(key)});
        }
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u4e2d...");
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u4fe1\u606f\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServerInfo()});
        String webRootPath = servletContextEvent.getServletContext().getRealPath("/");
        if (webRootPath == null) {
            try {
                webRootPath = servletContextEvent.getServletContext().getResource("/").getFile();
            }
            catch (MalformedURLException e) {
                logger.errorMessage("\u83b7\u53d6WEBROOT\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        logger.logMessage(LogLevel.INFO, "TINY_WEBROOT\uff1a[{0}]", new Object[]{webRootPath});
        ConfigurationUtil.getConfigurationManager().setConfiguration("TINY_WEBROOT", webRootPath);
        logger.logMessage(LogLevel.INFO, "\u5e94\u7528\u53c2\u6570<TINY_WEBROOT>=<{}>", new Object[]{webRootPath});
        logger.logMessage(LogLevel.INFO, "ServerContextName\uff1a[{0}]", new Object[]{servletContextEvent.getServletContext().getServletContextName()});
        logger.logMessage(LogLevel.INFO, "WEB\u73af\u5883\u5c5e\u6027\u7ed3\u675f");
        InputStream inputStream = this.getClass().getResourceAsStream("/application.xml");
        if (inputStream == null) {
            try {
                File file = new File(webRootPath + "/classes/application.xml");
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                logger.errorMessage("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
        }
        if (inputStream != null) {
            String applicationConfig = "";
            try {
                List processorConfigs;
                this.application = new ApplicationDefault();
                applicationConfig = StreamUtil.readText((InputStream)inputStream, (String)"UTF-8", (boolean)true);
                if (applicationConfig != null) {
                    ConfigurationManager c = ConfigurationUtil.getConfigurationManager();
                    XmlNode applicationXml = ConfigurationUtil.loadApplicationConfig((String)applicationConfig);
                    c.setApplicationConfiguration(applicationXml);
                }
                this.loadSpringBeans(applicationConfig);
                XmlNode applicationXml = ConfigurationUtil.getConfigurationManager().getApplicationConfiguration();
                if (applicationXml != null && (processorConfigs = applicationXml.getSubNodesRecursively("application-processor")) != null) {
                    for (XmlNode processorConfig : processorConfigs) {
                        String processorBean = processorConfig.getAttribute("bean");
                        ApplicationProcessor processor = (ApplicationProcessor)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(processorBean);
                        this.application.addApplicationProcessor(processor);
                    }
                }
            }
            catch (Exception e) {
                logger.errorMessage("\u8f7d\u5165\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}\uff01", (Throwable)e, new Object[]{e.getMessage()});
            }
            logger.logMessage(LogLevel.INFO, "\u542f\u52a8\u5e94\u7528\u5f00\u59cb...");
            this.application.init();
            this.application.start();
            FullContextFileRepository fileRepository = (FullContextFileRepository)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("fullContextFileRepository");
            servletContext.setFullContextFileRepository(fileRepository);
        }
        this.initContextListener(servletContextEvent);
        logger.logMessage(LogLevel.INFO, "WEB \u5e94\u7528\u542f\u52a8\u5b8c\u6210\u3002");
    }

    private void initContextListener(ServletContextEvent servletContextEvent) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<ServletContextListener> contextListeners = configManager.getContextListeners();
        for (ServletContextListener servletContextListener : contextListeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] will be Initialized", new Object[]{servletContextListener});
            servletContextListener.contextInitialized(servletContextEvent);
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] Initialized", new Object[]{servletContextListener});
        }
    }

    private void destroyContextListener(ServletContextEvent servletContextEvent) {
        TinyListenerConfigManager configManager = TinyListenerConfigManagerHolder.getInstance();
        List<ServletContextListener> contextListeners = configManager.getContextListeners();
        for (ServletContextListener servletContextListener : contextListeners) {
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] will be Destroyed", new Object[]{servletContextListener});
            servletContextListener.contextDestroyed(servletContextEvent);
            logger.logMessage(LogLevel.DEBUG, "ServletContextListener:[{0}] Destroyed", new Object[]{servletContextListener});
        }
    }

    private void loadSpringBeans(String applicationConfig) {
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u5f00\u59cb...");
        BeanContainerFactory.setBeanContainer((String)SpringBeanContainer.class.getName());
        FileResolver fileResolver = FileResolverFactory.getFileResolver();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        this.loadFileResolverConfig(fileResolver, applicationConfig);
        fileResolver.addResolvePath(FileResolverUtil.getClassPath((FileResolver)fileResolver));
        fileResolver.addResolvePath(FileResolverUtil.getWebClasses());
        try {
            fileResolver.addResolvePath(FileResolverUtil.getWebLibJars((FileResolver)fileResolver));
        }
        catch (Exception e) {
            logger.errorMessage("\u4e3a\u6587\u4ef6\u626b\u63cf\u5668\u6dfb\u52a0webLibJars\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new ConfigurationFileProcessor());
        fileResolver.resolve();
        logger.logMessage(LogLevel.INFO, "\u52a0\u8f7dSpring Bean\u6587\u4ef6\u7ed3\u675f\u3002");
    }

    private void loadFileResolverConfig(FileResolver fileResolver, String applicationConfig) {
        XmlStringParser parser = new XmlStringParser();
        XmlNode root = (XmlNode)parser.parse(applicationConfig).getRoot();
        PathFilter filter = new PathFilter((Node)root);
        XmlNode appConfig = (XmlNode)filter.findNode("/application/file-resolver-configuration");
        fileResolver.config(appConfig, null);
    }
}

