/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.configmanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.Configuration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.config.TinyFilterConfigInfo;
import org.tinygroup.weblayer.config.TinyFilterConfigInfos;
import org.tinygroup.weblayer.config.TinyWrapperFilterConfigInfo;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xstream.XStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyFilterConfigManager
implements Configuration {
    public static final String TINY_FILTER_CONFIGMANAGER = "tinyFilterConfigManager";
    private static final String TINY_FILTER_NODE_PATH = "/application/tiny-filters";
    private Map<String, TinyFilterConfigInfo> filterConfigMap = new HashMap<String, TinyFilterConfigInfo>();
    private List<TinyFilterConfigInfo> filterConfigs = new ArrayList<TinyFilterConfigInfo>();
    private List<TinyWrapperFilterConfigInfo> wrapperFilterConfigs = new ArrayList<TinyWrapperFilterConfigInfo>();
    private XmlNode applicationConfig;
    private XmlNode componentConfig;
    private static Logger logger = LoggerFactory.getLogger(TinyFilterConfigManager.class);

    public void addConfig(TinyFilterConfigInfos configInfos) {
        List<TinyFilterConfigInfo> configList = configInfos.getConfigs();
        for (TinyFilterConfigInfo configInfo : configList) {
            String name = configInfo.getConfigName();
            if (StringUtil.isBlank((String)name)) {
                logger.logMessage(LogLevel.WARN, "please set tiny filter name in name or id property");
            }
            if (this.filterConfigMap.containsKey(name)) {
                logger.logMessage(LogLevel.WARN, "already exist filter name:[{0}],please reset the filter name", new Object[]{name});
                continue;
            }
            if (configInfo instanceof TinyWrapperFilterConfigInfo) {
                this.wrapperFilterConfigs.add((TinyWrapperFilterConfigInfo)configInfo);
            } else {
                this.filterConfigs.add(configInfo);
            }
            this.filterConfigMap.put(name, configInfo);
        }
    }

    public void removeConfig(TinyFilterConfigInfos configInfos) {
        List<TinyFilterConfigInfo> configList = configInfos.getConfigs();
        for (TinyFilterConfigInfo configInfo : configList) {
            String name = configInfo.getConfigName();
            this.filterConfigMap.remove(name);
            if (configInfo instanceof TinyWrapperFilterConfigInfo) {
                this.wrapperFilterConfigs.remove((TinyWrapperFilterConfigInfo)configInfo);
                continue;
            }
            this.filterConfigs.remove(configInfo);
        }
    }

    public XmlNode getApplicationConfig() {
        return this.applicationConfig;
    }

    public String getApplicationNodePath() {
        return TINY_FILTER_NODE_PATH;
    }

    public String getComponentConfigPath() {
        return "/tinyfilter.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        this.applicationConfig = applicationConfig;
        this.componentConfig = componentConfig;
    }

    private void combineConfig(List<XmlNode> combineList) {
        XStream stream = XStreamFactory.getXStream((String)"weblayer");
        for (XmlNode xmlNode : combineList) {
            TinyFilterConfigInfos filterConfigInfos = (TinyFilterConfigInfos)stream.fromXML(xmlNode.toString());
            List<TinyFilterConfigInfo> configInfos = filterConfigInfos.getConfigs();
            for (TinyFilterConfigInfo configInfo : configInfos) {
                String name = configInfo.getConfigName();
                if (this.filterConfigMap.containsKey(name)) {
                    TinyFilterConfigInfo originalInfo = this.filterConfigMap.get(name);
                    logger.logMessage(LogLevel.DEBUG, "filter name:[{0}] combine [{1}] with [{2}]", new Object[]{name, originalInfo, configInfo});
                    originalInfo.combine(configInfo);
                    continue;
                }
                if (configInfo instanceof TinyWrapperFilterConfigInfo) {
                    this.wrapperFilterConfigs.add((TinyWrapperFilterConfigInfo)configInfo);
                } else {
                    this.filterConfigs.add(configInfo);
                }
                this.filterConfigMap.put(name, configInfo);
            }
        }
    }

    public void combineConfig() {
        ArrayList<XmlNode> combineList = new ArrayList<XmlNode>();
        if (this.componentConfig != null) {
            combineList.add(this.componentConfig);
        }
        if (this.applicationConfig != null) {
            combineList.add(this.applicationConfig);
        }
        this.combineConfig(combineList);
    }

    public XmlNode getComponentConfig() {
        return this.componentConfig;
    }

    public TinyFilterConfigInfo getFilterConfig(String filterName) {
        return this.filterConfigMap.get(filterName);
    }

    public List<TinyFilterConfigInfo> getFilterConfigs() {
        return this.filterConfigs;
    }

    public List<TinyWrapperFilterConfigInfo> getWrapperFilterConfigs() {
        return this.wrapperFilterConfigs;
    }
}

