/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.exceptionhandler;

import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandler;
import org.tinygroup.weblayer.exceptionhandler.WebExceptionHandlerManager;
import org.tinygroup.xmlparser.node.XmlNode;

public class WebExceptionProcessor
extends AbstractConfiguration {
    private static final String EXCEPTION_CONFIG_PATH = "/application/exception-config/exception-handlers";
    private WebExceptionHandlerManager webHandlerManager;

    public WebExceptionHandlerManager getWebHandlerManager() {
        return this.webHandlerManager;
    }

    public void setWebHandlerManager(WebExceptionHandlerManager webHandlerManager) {
        this.webHandlerManager = webHandlerManager;
    }

    public String getApplicationNodePath() {
        return EXCEPTION_CONFIG_PATH;
    }

    public String getComponentConfigPath() {
        return "webexceptionhandler.config.xml";
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        super.config(applicationConfig, componentConfig);
        List webHandlerList = ConfigurationUtil.combineSubList((String)"web-exception-handler", (XmlNode)applicationConfig, (XmlNode)componentConfig);
        for (XmlNode handler : webHandlerList) {
            String exception = handler.getAttribute("exception");
            String handlerBean = handler.getAttribute("handler");
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0web-exception-handler,Exception:{0},handerBean:{1}", new Object[]{exception, handlerBean});
            WebExceptionHandler exceptionHandler = (WebExceptionHandler)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(handlerBean);
            try {
                this.webHandlerManager.addHandler(exception, exceptionHandler);
            }
            catch (ClassNotFoundException e) {
                logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0web-exception-handler\u51fa\u73b0\u5f02\u5e38,Exception\u7c7b:{0}\u627e\u4e0d\u5230", new Object[]{exception, handlerBean});
                continue;
            }
            logger.logMessage(LogLevel.INFO, "\u6dfb\u52a0web-exception-handler,Exception:{0},handerBean:{1}\u5b8c\u6210", new Object[]{exception, handlerBean});
        }
    }
}

