/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.basic.impl.BasicWebContextImpl;

public class BasicTinyFilter
extends AbstractTinyFilter {
    private Object[] interceptors;
    private String maxCookieSize;
    private static final String MAX_COOKIE_SIZE = "maxCookieSize";

    public void setInterceptors(Object[] interceptors) {
        this.interceptors = interceptors;
    }

    public void setMaxCookieSize(String maxCookieSize) {
        this.maxCookieSize = maxCookieSize;
    }

    protected void customInit() {
        if (this.maxCookieSize == null) {
            this.maxCookieSize = this.get(MAX_COOKIE_SIZE);
        }
    }

    public void preProcess(WebContext context) throws ServletException, IOException {
        BasicWebContextImpl basic = (BasicWebContextImpl)context;
        basic.prepareResponse();
    }

    public void postProcess(WebContext context) throws ServletException, IOException {
        BasicWebContextImpl basic = (BasicWebContextImpl)context;
        basic.commitResponse();
    }

    public WebContext getAlreadyWrappedContext(WebContext wrappedContext) {
        BasicWebContextImpl basic = new BasicWebContextImpl(wrappedContext);
        basic.setMaxCookieSize(this.maxCookieSize);
        return basic;
    }

    protected void initContext(WebContext context) {
        super.initContext(context);
        ((BasicWebContextImpl)context).initContext(this.interceptors);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

