/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.TinyFilterConfig;
import org.tinygroup.weblayer.config.FilterMapping;
import org.tinygroup.weblayer.config.TinyFilterConfigInfo;
import org.tinygroup.weblayer.impl.SimpleBasicTinyConfig;

public class DefaultTinyFilterConfig
extends SimpleBasicTinyConfig
implements TinyFilterConfig {
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private List<String> patternStrs = new ArrayList<String>();

    public DefaultTinyFilterConfig(TinyFilterConfigInfo config) {
        super(config.getConfigName(), config);
        this.setFilterConfig(config);
    }

    private void setFilterConfig(TinyFilterConfigInfo config) {
        List<FilterMapping> filterMappings = config.getFilterMappings();
        for (FilterMapping filterMapping : filterMappings) {
            String urlPattern = filterMapping.getUrlPattern();
            if (!this.patternStrs.contains(urlPattern)) {
                this.patterns.add(Pattern.compile(urlPattern));
                this.patternStrs.add(urlPattern);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684url-pattern:'{}'", new Object[]{this.configName, urlPattern});
        }
    }

    public boolean isMatch(String url) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>,\u5339\u914d\u7684tiny-filter:<{}>", new Object[]{url, this.configName});
            return true;
        }
        return false;
    }
}

