/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.weblayer.TinyProcessorConfig;
import org.tinygroup.weblayer.config.ServletMapping;
import org.tinygroup.weblayer.config.TinyProcessorConfigInfo;
import org.tinygroup.weblayer.impl.SimpleBasicTinyConfig;

public class DefaultTinyProcessorConfig
extends SimpleBasicTinyConfig
implements TinyProcessorConfig {
    private List<Pattern> patterns = new ArrayList<Pattern>();
    private List<String> patternStrs = new ArrayList<String>();

    public DefaultTinyProcessorConfig(TinyProcessorConfigInfo config) {
        super(config.getConfigName(), config);
        this.setProcessorConfig(config);
    }

    private void setProcessorConfig(TinyProcessorConfigInfo config) {
        this.parameterMap = config.getParameterMap();
        List<ServletMapping> filterMappings = config.getServletMappings();
        for (ServletMapping filterMapping : filterMappings) {
            String urlPattern = filterMapping.getUrlPattern();
            if (!this.patternStrs.contains(urlPattern)) {
                this.patterns.add(Pattern.compile(urlPattern));
                this.patternStrs.add(urlPattern);
            }
            logger.logMessage(LogLevel.DEBUG, "<{}>\u7684url-pattern:'{}'", new Object[]{this.configName, urlPattern});
        }
    }

    public boolean isMatch(String url) {
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.matches()) continue;
            logger.logMessage(LogLevel.DEBUG, "\u8bf7\u6c42\u8def\u5f84\uff1a<{}>,\u5339\u914d\u7684tiny-processor:<{}>", new Object[]{url, this.configName});
            return true;
        }
        return false;
    }
}

