/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.mvc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.ReflectionUtils;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context2object.impl.ClassNameObjectGenerator;
import org.tinygroup.loader.LoaderManager;
import org.tinygroup.springutil.MethodNameAccessTool;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.mvc.MappingClassModel;
import org.tinygroup.weblayer.mvc.MappingMethodModel;
import org.tinygroup.weblayer.mvc.WebContextAware;
import org.tinygroup.weblayer.mvc.annotation.View;

public class HandlerExecutionChain {
    private MappingClassModel model;
    private MappingMethodModel methodModel;
    private WebContext context;

    public HandlerExecutionChain(MappingClassModel model, MappingMethodModel methodModel) {
        this.model = model;
        this.methodModel = methodModel;
    }

    public MappingClassModel getModel() {
        return this.model;
    }

    public void setModel(MappingClassModel model) {
        this.model = model;
    }

    public MappingMethodModel getMethodModel() {
        return this.methodModel;
    }

    public void setMethodModel(MappingMethodModel methodModel) {
        this.methodModel = methodModel;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void setContext(WebContext context) {
        this.context = context;
    }

    public void execute() throws ServletException, IOException, ClassNotFoundException {
        View view;
        Object result;
        Method method = this.methodModel.getMapMethod();
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        String[] parameterNames = MethodNameAccessTool.getMethodParameterName((Method)method);
        for (int i = 0; i < paramTypes.length; ++i) {
            args[i] = this.context.get(parameterNames[i]);
            Class<?> type = paramTypes[i];
            if (args[i] == null) {
                if (type.equals(WebContext.class)) {
                    args[i] = this.context;
                } else {
                    ClassNameObjectGenerator generator = (ClassNameObjectGenerator)BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean("classNameObjectGenerator");
                    if (Collection.class.isAssignableFrom(type)) {
                        ParameterizedType pt = (ParameterizedType)method.getGenericParameterTypes()[i];
                        Type[] actualTypeArguments = pt.getActualTypeArguments();
                        ClassLoader loader = LoaderManager.getLoader((String)this.getClassName(actualTypeArguments[0].toString()));
                        args[i] = generator.getObjectCollection(null, type.getName(), this.getClassName(actualTypeArguments[0].toString()), loader, (Context)this.context);
                    } else {
                        ClassLoader loader = LoaderManager.getLoader((String)type.getName());
                        args[i] = generator.getObject(null, null, type.getName(), loader, (Context)this.context);
                    }
                }
            } else {
                args[i] = ValueUtil.getValue((String)args[i].toString(), (String)type.getName());
            }
            this.context.put(parameterNames[i], args[i]);
        }
        Object object = this.getInstance(this.model.getMapClass());
        if (object instanceof WebContextAware) {
            ((WebContextAware)object).setContext(this.context);
        }
        if ((result = ReflectionUtils.invokeMethod((Method)method, (Object)object, (Object[])args)) != null && this.methodModel.getResultKey() != null) {
            this.context.put(this.methodModel.getResultKey().value(), result);
        }
        if ((view = this.methodModel.getView()) != null) {
            String pathInfo = view.value();
            HttpServletRequest request = this.context.getRequest();
            request.getRequestDispatcher(pathInfo).forward((ServletRequest)request, (ServletResponse)this.context.getResponse());
        }
    }

    private Object getInstance(Class mapClass) {
        Object object;
        block4: {
            object = null;
            try {
                object = BeanContainerFactory.getBeanContainer((ClassLoader)this.getClass().getClassLoader()).getBean(mapClass);
            }
            catch (Exception e) {
                if (object != null) break block4;
                try {
                    object = this.model.getMapClass().newInstance();
                }
                catch (Exception e1) {
                    throw new IllegalStateException("\u5b9e\u4f8b\u5316\u51fa\u9519", e1);
                }
            }
        }
        return object;
    }

    private String getClassName(String rawType) {
        if (rawType == null || "".equals(rawType)) {
            throw new RuntimeException("\u88ab\u89e3\u6790\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        }
        if (rawType.startsWith("interface ")) {
            return rawType.substring("interface ".length());
        }
        if (rawType.startsWith("class ")) {
            return rawType.substring("class ".length());
        }
        return rawType;
    }
}

