/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.mvc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.weblayer.mvc.MappingMethodModel;
import org.tinygroup.weblayer.mvc.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingClassModel {
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Class mapClass;
    private RequestMapping classMapping;
    private List<MappingMethodModel> mappingMethodModels;
    private Map<String, MappingMethodModel> urlMapping;
    private Set<String> urlPatterns;

    public MappingClassModel(Class mapClass, RequestMapping classMapping) {
        this.mapClass = mapClass;
        this.classMapping = classMapping;
        if (this.mappingMethodModels == null) {
            this.mappingMethodModels = CollectionUtil.createArrayList();
        }
        if (this.urlPatterns == null) {
            this.urlPatterns = CollectionUtil.createHashSet();
        }
        if (this.urlMapping == null) {
            this.urlMapping = CollectionUtil.createHashMap();
        }
    }

    public Class getMapClass() {
        return this.mapClass;
    }

    public void setMapClass(Class mapClass) {
        this.mapClass = mapClass;
    }

    public RequestMapping getClassMapping() {
        return this.classMapping;
    }

    public void setClassMapping(RequestMapping classMapping) {
        this.classMapping = classMapping;
    }

    public void addMethodModel(MappingMethodModel methodModel) {
        this.mappingMethodModels.add(methodModel);
    }

    public List<MappingMethodModel> getMappingMethodModels() {
        return this.mappingMethodModels;
    }

    public void putUrlMapping(String urlPattern, MappingMethodModel methodModel) {
        this.urlPatterns.add(urlPattern);
        this.urlMapping.put(urlPattern, methodModel);
    }

    public void putUrlMappings(Set<String> urlPatterns, MappingMethodModel methodModel) {
        for (String urlPattern : urlPatterns) {
            this.putUrlMapping(urlPattern, methodModel);
        }
    }

    public Map<String, MappingMethodModel> getUrlMapping() {
        return this.urlMapping;
    }

    public MappingMethodModel removeMappingMethodWithUrlPattern(String urlPattern) {
        this.urlPatterns.remove(urlPattern);
        return this.urlMapping.remove(urlPattern);
    }

    public MappingMethodModel getMappingMethodWithUrlPattern(String urlPattern) {
        return this.urlMapping.get(urlPattern);
    }
}

