/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.mvc.impl;

import java.util.Map;
import java.util.Set;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.weblayer.mvc.HandlerExecutionChain;
import org.tinygroup.weblayer.mvc.MappingClassModel;
import org.tinygroup.weblayer.mvc.MappingMethodModel;
import org.tinygroup.weblayer.mvc.MappingModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingModelManagerImpl
implements MappingModelManager {
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Map<Class, MappingClassModel> classModels = CollectionUtil.createHashMap();
    private Map<String, MappingClassModel> urlModels = CollectionUtil.createHashMap();

    @Override
    public void putMappingModel(Class clazz, MappingClassModel model) {
        this.classModels.put(clazz, model);
    }

    @Override
    public MappingClassModel getMappingModelWithClass(Class clazz) {
        return this.classModels.get(clazz);
    }

    @Override
    public Set<Class> getMappingClasses() {
        return this.classModels.keySet();
    }

    @Override
    public HandlerExecutionChain getMappingModelWithUrl(String url) {
        Set<String> urlPatterns = this.urlModels.keySet();
        for (String urlPattern : urlPatterns) {
            if (!this.pathMatcher.match(urlPattern, url)) continue;
            MappingClassModel model = this.urlModels.get(urlPattern);
            MappingMethodModel methodModel = model.getMappingMethodWithUrlPattern(urlPattern);
            return new HandlerExecutionChain(model, methodModel);
        }
        return null;
    }

    @Override
    public void putUrlMappings(Set<String> urlPatterns, MappingClassModel model) {
        for (String urlPattern : urlPatterns) {
            this.putUrlMapping(urlPattern, model);
        }
    }

    @Override
    public void putUrlMapping(String urlPattern, MappingClassModel model) {
        this.urlModels.put(urlPattern, model);
    }
}

