/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.fileresolver.FullContextFileRepository;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class FullContextUrlRedirectTinyProcessor
extends AbstractTinyProcessor {
    private static final String CACHE_CONTROL = "max-age=315360000";
    private FullContextFileRepository fullContextFileRepository;
    private static final Logger logger = LoggerFactory.getLogger(FullContextUrlRedirectTinyProcessor.class);

    public FullContextFileRepository getFullContextFileRepository() {
        return this.fullContextFileRepository;
    }

    public void setFullContextFileRepository(FullContextFileRepository fullContextFileRepository) {
        this.fullContextFileRepository = fullContextFileRepository;
    }

    protected void customInit() throws ServletException {
    }

    public void reallyProcess(String servletPath, WebContext context) throws ServletException, IOException {
        logger.logMessage(LogLevel.DEBUG, "{}\u5f00\u59cb\u5904\u7406...", new Object[]{servletPath});
        HttpServletResponse response = context.getResponse();
        HttpServletRequest request = context.getRequest();
        FileObject fileObject = this.fullContextFileRepository.getFileObject(servletPath);
        if (fileObject != null && fileObject.isExist()) {
            String ims = request.getHeader("If-Modified-Since");
            if (ims != null && ims.length() > 0 && ims.equals(new Date(fileObject.getLastModifiedTime()).toGMTString())) {
                response.setStatus(304);
                return;
            }
            String dateString = new Date(fileObject.getLastModifiedTime()).toGMTString();
            response.setStatus(200);
            response.setHeader("Last-modified", dateString);
            response.setHeader("Connection", "keep-alive");
            response.setHeader("Cache-Control", CACHE_CONTROL);
            response.setHeader("Date", dateString);
            response.setContentType(this.fullContextFileRepository.getFileContentType(fileObject.getExtName()));
            ServletOutputStream outputStream = response.getOutputStream();
            BufferedInputStream stream = new BufferedInputStream(fileObject.getInputStream());
            byte[] buffer = new byte[((InputStream)stream).available()];
            ((InputStream)stream).read(buffer);
            ((InputStream)stream).close();
            outputStream.write(buffer);
            outputStream.close();
            logger.logMessage(LogLevel.DEBUG, "{}\u5904\u7406\u5b8c\u6210\u3002", new Object[]{servletPath});
        } else {
            logger.logMessage(LogLevel.DEBUG, "{}\u672a\u627e\u5230\u3002", new Object[]{servletPath});
            response.setStatus(404);
        }
    }
}

