/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.tinyprocessor;

import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.context.Context;
import org.tinygroup.convert.objectjson.fastjson.ObjectToJson;
import org.tinygroup.convert.objectxml.xstream.ObjectToXml;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.event.ServiceRequest;
import org.tinygroup.service.ServiceMappingManager;
import org.tinygroup.service.config.ServiceViewMapping;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class ServiceTinyProcessor
extends AbstractTinyProcessor {
    ServiceMappingManager manager;
    CEPCore core;
    ObjectToXml<Object> objectToXml = new ObjectToXml();
    ObjectToJson<Object> objectToJson = new ObjectToJson(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }

    public ServiceMappingManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceMappingManager manager) {
        this.manager = manager;
    }

    private Object callService(String serviceId, Context context) {
        Event event = new Event();
        ServiceRequest sq = new ServiceRequest();
        sq.setServiceId(serviceId);
        sq.setContext(context);
        event.setServiceRequest(sq);
        this.core.process(event);
        ServiceInfo info = this.core.getServiceInfo(serviceId);
        List resultsParam = info.getResults();
        if (resultsParam == null || resultsParam.size() == 0) {
            return null;
        }
        return event.getServiceRequest().getContext().get(((Parameter)resultsParam.get(0)).getName());
    }

    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        int lastSplash = urlString.lastIndexOf(47);
        int lastDot = urlString.lastIndexOf(46);
        String serviceId = urlString.substring(lastSplash + 1, lastDot);
        Object result = this.callService(serviceId, context);
        if (urlString.endsWith("servicexml") && result != null) {
            context.getResponse().getWriter().write(this.objectToXml.convert(result));
        } else if (urlString.endsWith(".servicejson") && result != null) {
            context.getResponse().getWriter().write(this.objectToJson.convert(result));
        } else if (urlString.endsWith(".servicepage")) {
            ServiceViewMapping viewMapping = this.manager.getServiceViewMapping(serviceId);
            if (viewMapping == null) {
                throw new RuntimeException(serviceId + "\u5bf9\u5e94\u7684\u5c55\u73b0\u89c6\u56fe\u4e0d\u5b58\u5728\uff01");
            }
            String path = viewMapping.getPath();
            this.checkPath(serviceId, path);
            this.pageJump(path, viewMapping.getType(), context);
        } else if (urlString.endsWith(".servicepagelet")) {
            ServiceViewMapping viewMapping = this.manager.getServiceViewMapping(serviceId);
            if (viewMapping == null) {
                throw new RuntimeException(serviceId + "\u5bf9\u5e94\u7684\u5c55\u73b0\u89c6\u56fe\u4e0d\u5b58\u5728\uff01");
            }
            String path = viewMapping.getPath();
            this.checkPath(serviceId, path);
            if (path.endsWith(".page")) {
                path = path + "let";
            }
            this.pageJump(path, viewMapping.getType(), context);
        }
    }

    private void pageJump(String path, String type, WebContext context) throws ServletException, IOException {
        if ("forward".equals(type)) {
            context.getRequest().getRequestDispatcher(path).forward((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
        } else if ("redirect".equals(type)) {
            String contextPath = (String)context.get("TINY_CONTEXT_PATH");
            contextPath = path.startsWith("/") ? contextPath + path : contextPath + "/" + path;
            context.getResponse().sendRedirect(contextPath);
        } else {
            throw new RuntimeException(type + "\u8df3\u8f6c\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u662fforward\u6216\u8005redirect");
        }
    }

    private void checkPath(String serviceId, String path) {
        if (path == null) {
            throw new RuntimeException(serviceId + "\u5bf9\u5e94\u7684\u5c55\u73b0\u89c6\u56fe\u4e0d\u5b58\u5728\uff01");
        }
    }

    protected void customInit() throws ServletException {
    }
}

