/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.basic.interceptor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.tinygroup.commons.tools.HumanReadableSize;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.basic.exception.ResponseHeaderRejectedException;
import org.tinygroup.weblayer.webcontext.basic.interceptor.CookieHeaderValueInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.CookieInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.HeaderNameInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.HeaderValueInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.RedirectLocationInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.StatusMessageInterceptor;
import org.tinygroup.weblayer.webcontext.basic.interceptor.WebContextLifecycleInterceptor;
import org.tinygroup.weblayer.webcontext.util.CookieSupport;

public class ResponseHeaderSecurityFilter
implements WebContextLifecycleInterceptor,
HeaderNameInterceptor,
HeaderValueInterceptor,
CookieInterceptor,
CookieHeaderValueInterceptor,
StatusMessageInterceptor,
RedirectLocationInterceptor {
    public static final HumanReadableSize MAX_SET_COOKIE_SIZE_DEFAULT = new HumanReadableSize("7k");
    private static final String COOKIE_LENGTH_ATTR = "_COOKIE_LENGTH_";
    private static final Pattern crlf = Pattern.compile("\\r\\n|\\r|\\n");
    private final Logger log = LoggerFactory.getLogger(ResponseHeaderSecurityFilter.class);
    private final CookieLengthAccumulator cookieLengthAccumulator;
    private HumanReadableSize maxCookieSize;

    public ResponseHeaderSecurityFilter() {
        this(null);
    }

    public ResponseHeaderSecurityFilter(HttpServletRequest request) {
        this.cookieLengthAccumulator = request == null ? new ThreadLocalBasedCookieLengthAccumulator() : new RequestBasedCookieLengthAccumulator(request);
    }

    public HumanReadableSize getMaxCookieSize() {
        return this.maxCookieSize == null || this.maxCookieSize.getValue() <= 0L ? MAX_SET_COOKIE_SIZE_DEFAULT : this.maxCookieSize;
    }

    public void setMaxCookieSize(HumanReadableSize maxSetCookieSize) {
        this.maxCookieSize = maxSetCookieSize;
    }

    public void prepare() {
    }

    public void commitHeaders() {
        this.cookieLengthAccumulator.reset();
    }

    public void commit() {
    }

    public String checkHeaderName(String name) {
        if (this.containsCRLF(name)) {
            String msg = "Invalid response header: " + StringEscapeUtil.escapeJava((String)name);
            this.log.logMessage(LogLevel.ERROR, msg);
            throw new ResponseHeaderRejectedException(msg);
        }
        return name;
    }

    public String checkHeaderValue(String name, String value) {
        return (String)ObjectUtil.defaultIfNull((Object)this.filterCRLF(value, "header " + name), (Object)value);
    }

    public Cookie checkCookie(Cookie cookie) {
        String name = cookie.getName();
        if (this.containsCRLF(name)) {
            this.log.logMessage(LogLevel.ERROR, "Invalid cookie name: " + StringEscapeUtil.escapeJava((String)name));
            return null;
        }
        String value = cookie.getValue();
        String filteredValue = this.filterCRLF(value, "cookie " + name);
        if (filteredValue == null) {
            return cookie;
        }
        CookieSupport newCookie = new CookieSupport(cookie);
        newCookie.setValue(filteredValue);
        return newCookie;
    }

    public String checkCookieHeaderValue(String name, String value, boolean setHeader) {
        if (value != null) {
            int maxCookieSize = (int)this.getMaxCookieSize().getValue();
            int length = this.cookieLengthAccumulator.getLength();
            if (length + value.length() > maxCookieSize) {
                this.log.logMessage(LogLevel.ERROR, "Cookie size exceeds the max value: {} + {} > maxSize {}.  Cookie is ignored: {}", new Object[]{length, value.length(), this.getMaxCookieSize(), value});
                return "";
            }
            if (setHeader) {
                this.cookieLengthAccumulator.setCookie(value);
            } else {
                this.cookieLengthAccumulator.addCookie(value);
            }
        }
        return value;
    }

    public String checkStatusMessage(int sc, String msg) {
        return StringEscapeUtil.escapeHtml((String)msg);
    }

    public String checkRedirectLocation(String location) {
        return (String)ObjectUtil.defaultIfNull((Object)this.filterCRLF(location, "redirectLocation"), (Object)location);
    }

    private boolean containsCRLF(String str) {
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '\n': 
                    case '\r': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String filterCRLF(String value, String logInfo) {
        if (this.containsCRLF(value)) {
            this.log.logMessage(LogLevel.WARN, "Found CRLF in {}: {}", new Object[]{logInfo, StringEscapeUtil.escapeJava((String)value)});
            StringBuffer sb = new StringBuffer();
            Matcher m = crlf.matcher(value);
            while (m.find()) {
                m.appendReplacement(sb, " ");
            }
            m.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private final class RequestBasedCookieLengthAccumulator
    extends CookieLengthAccumulator {
        private final HttpServletRequest request;

        private RequestBasedCookieLengthAccumulator(HttpServletRequest request) {
            this.request = request;
        }

        public int getLength() {
            Object value = this.request.getAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }

        protected void setLength(int length) {
            this.request.setAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR, (Object)length);
        }

        protected void reset() {
            this.request.removeAttribute(ResponseHeaderSecurityFilter.COOKIE_LENGTH_ATTR);
        }
    }

    private final class ThreadLocalBasedCookieLengthAccumulator
    extends CookieLengthAccumulator {
        private final ThreadLocal<Integer> cookieLengthHolder;

        private ThreadLocalBasedCookieLengthAccumulator() {
            this.cookieLengthHolder = new ThreadLocal();
        }

        public int getLength() {
            Integer value = this.cookieLengthHolder.get();
            if (value instanceof Integer) {
                return value;
            }
            return 0;
        }

        protected void setLength(int length) {
            this.cookieLengthHolder.set(length);
        }

        protected void reset() {
            this.cookieLengthHolder.remove();
        }
    }

    private static abstract class CookieLengthAccumulator {
        private CookieLengthAccumulator() {
        }

        public final void addCookie(String cookie) {
            this.setLength(this.getLength() + cookie.length());
        }

        public final void setCookie(String cookie) {
            this.setLength(cookie.length());
        }

        public abstract int getLength();

        protected abstract void setLength(int var1);

        protected abstract void reset();
    }
}

