/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.buffered.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.LinkedList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.tinygroup.commons.io.ByteArray;
import org.tinygroup.commons.io.ByteArrayInputStream;
import org.tinygroup.commons.io.ByteArrayOutputStream;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.commons.tools.ObjectUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.AbstractTinyFilter;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractResponseWrapper;

public class BufferedResponseImpl
extends AbstractResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTinyFilter.class);
    private boolean buffering = true;
    private Stack<ByteArrayOutputStream> bytesStack;
    private Stack<StringWriter> charsStack;
    private ServletOutputStream stream;
    private PrintWriter streamAdapter;
    private PrintWriter writer;
    private ServletOutputStream writerAdapter;

    public BufferedResponseImpl(WebContext webContext, HttpServletResponse response) {
        super(webContext, response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.writer != null) {
            if (this.writerAdapter != null) {
                return this.writerAdapter;
            }
            logger.logMessage(LogLevel.DEBUG, "Attampt to getOutputStream after calling getWriter.  This may cause unnecessary system cost.");
            this.writerAdapter = new WriterOutputStream(this.writer, this.getCharacterEncoding());
            return this.writerAdapter;
        }
        if (this.buffering) {
            if (this.bytesStack == null) {
                this.bytesStack = new Stack();
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.bytesStack.push(bytes);
            this.stream = new BufferedServletOutputStream(bytes);
            logger.logMessage(LogLevel.DEBUG, "Created new byte buffer");
        } else {
            this.stream = super.getOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            if (this.streamAdapter != null) {
                return this.streamAdapter;
            }
            logger.logMessage(LogLevel.DEBUG, "Attampt to getWriter after calling getOutputStream.  This may cause unnecessary system cost.");
            this.streamAdapter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.stream, this.getCharacterEncoding()), true);
            return this.streamAdapter;
        }
        if (this.buffering) {
            if (this.charsStack == null) {
                this.charsStack = new Stack();
            }
            StringWriter chars = new StringWriter();
            this.charsStack.push(chars);
            this.writer = new BufferedServletWriter(chars);
            logger.logMessage(LogLevel.DEBUG, "Created new character buffer");
        } else {
            this.writer = super.getWriter();
        }
        return this.writer;
    }

    public void setContentLength(int length) {
        if (!this.buffering) {
            super.setContentLength(length);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.buffering) {
            this.flushBufferAdapter();
            if (this.writer != null) {
                this.writer.flush();
            } else if (this.stream != null) {
                this.stream.flush();
            }
        } else {
            super.flushBuffer();
        }
    }

    public void resetBuffer() {
        if (this.buffering) {
            this.flushBufferAdapter();
            if (this.stream != null) {
                this.bytesStack.clear();
                this.bytesStack.add(new ByteArrayOutputStream());
                ((BufferedServletOutputStream)this.stream).updateOutputStream(this.bytesStack.peek());
            }
            if (this.writer != null) {
                this.charsStack.clear();
                this.charsStack.add(new StringWriter());
                ((BufferedServletWriter)this.writer).updateWriter(this.charsStack.peek());
            }
        }
        super.resetBuffer();
    }

    public boolean isBuffering() {
        return this.buffering;
    }

    public void setBuffering(boolean buffering) {
        if (this.stream == null && this.writer == null) {
            if (this.buffering != buffering) {
                this.buffering = buffering;
                logger.logMessage(LogLevel.DEBUG, "Set buffering " + (buffering ? "on" : "off"));
            }
        } else if (this.buffering != buffering) {
            throw new IllegalStateException("Unable to change the buffering mode since the getOutputStream() or getWriter() method has been called");
        }
    }

    public void pushBuffer() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required to pushBuffer");
        }
        if (this.stream == null && this.writer == null) {
            throw new IllegalStateException("getOutputStream() or getWriter() method has not been called yet");
        }
        this.flushBufferAdapter();
        if (this.stream != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.bytesStack.push(bytes);
            ((BufferedServletOutputStream)this.stream).updateOutputStream(this.bytesStack.peek());
            logger.logMessage(LogLevel.DEBUG, "Pushed new byte buffer (stack size is " + this.bytesStack.size() + ")");
        } else {
            StringWriter chars = new StringWriter();
            this.charsStack.push(chars);
            ((BufferedServletWriter)this.writer).updateWriter(this.charsStack.peek());
            logger.logMessage(LogLevel.DEBUG, "Pushed new character buffer (stack size is " + this.charsStack.size() + ")");
        }
    }

    public ByteArray popByteBuffer() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required to popByteBuffer");
        }
        if (this.writer != null) {
            throw new IllegalStateException("Unable to popByteBuffer() since the getWriter() method has been called");
        }
        if (this.stream == null) {
            return new ByteArray(BasicConstant.EMPTY_BYTE_ARRAY, 0, 0);
        }
        this.flushBufferAdapter();
        ByteArrayOutputStream block = this.bytesStack.pop();
        if (this.bytesStack.size() == 0) {
            this.bytesStack.push(new ByteArrayOutputStream());
        }
        ((BufferedServletOutputStream)this.stream).updateOutputStream(this.bytesStack.peek());
        logger.logMessage(LogLevel.DEBUG, "Popped the last byte buffer (stack size is " + this.bytesStack.size() + ")");
        return block.toByteArray();
    }

    public ByteArray peekByteBuffer() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required to popByteBuffer");
        }
        if (this.writer != null) {
            throw new IllegalStateException("Unable to popByteBuffer() since the getWriter() method has been called");
        }
        if (this.stream == null) {
            return new ByteArray(BasicConstant.EMPTY_BYTE_ARRAY, 0, 0);
        }
        this.flushBufferAdapter();
        ByteArrayOutputStream block = this.bytesStack.peek();
        return block.toByteArray();
    }

    public String popCharBuffer() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required to popCharBuffer");
        }
        if (this.stream != null) {
            throw new IllegalStateException("Unable to popCharBuffer() since the getOutputStream() method has been called");
        }
        if (this.writer == null) {
            return "";
        }
        this.flushBufferAdapter();
        StringWriter block = this.charsStack.pop();
        if (this.charsStack.size() == 0) {
            this.charsStack.push(new StringWriter());
        }
        ((BufferedServletWriter)this.writer).updateWriter(this.charsStack.peek());
        logger.logMessage(LogLevel.DEBUG, "Popped the last character buffer (stack size is " + this.charsStack.size() + ")");
        return block.toString();
    }

    public String peekCharBuffer() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required to popCharBuffer");
        }
        if (this.stream != null) {
            throw new IllegalStateException("Unable to popCharBuffer() since the getOutputStream() method has been called");
        }
        if (this.writer == null) {
            return "";
        }
        this.flushBufferAdapter();
        StringWriter block = this.charsStack.peek();
        return block.toString();
    }

    public void commitBuffer() throws IOException {
        if (this.stream == null && this.writer == null) {
            return;
        }
        if (!this.buffering) {
            throw new IllegalStateException("Buffering mode is required for commitBuffer");
        }
        if (this.stream != null) {
            if (this.bytesStack.size() > 1) {
                throw new IllegalStateException("More than 1 byte-buffers in the stack");
            }
            this.flushBufferAdapter();
            ServletOutputStream ostream = super.getOutputStream();
            ByteArray bytes = this.popByteBuffer();
            bytes.writeTo((OutputStream)ostream);
            ostream.flush();
            logger.logMessage(LogLevel.DEBUG, "Committed buffered bytes to the Servlet output stream");
        }
        if (this.writer != null) {
            if (this.charsStack.size() > 1) {
                throw new IllegalStateException("More than 1 char-buffers in the stack");
            }
            this.flushBufferAdapter();
            PrintWriter writer = super.getWriter();
            String chars = this.popCharBuffer();
            writer.write(chars);
            writer.flush();
            logger.logMessage(LogLevel.DEBUG, "Committed buffered characters to the Servlet writer");
        }
    }

    private void flushBufferAdapter() {
        if (this.streamAdapter != null) {
            this.streamAdapter.flush();
        }
        if (this.writerAdapter != null) {
            try {
                this.writerAdapter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class WriterOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private Writer writer;
        private String charset;

        public WriterOutputStream(Writer writer, String charset) {
            this.writer = writer;
            this.charset = (String)ObjectUtil.defaultIfNull((Object)charset, (Object)"ISO-8859-1");
        }

        public void write(int b) throws IOException {
            this.buffer.write((int)((byte)b));
        }

        public void write(byte[] b) throws IOException {
            this.buffer.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.buffer.write(b, off, len);
        }

        public void flush() throws IOException {
            ByteArray bytes = this.buffer.toByteArray();
            if (bytes.getLength() > 0) {
                ByteArrayInputStream inputBytes = new ByteArrayInputStream(bytes.getRawBytes(), bytes.getOffset(), bytes.getLength());
                InputStreamReader reader = new InputStreamReader((InputStream)inputBytes, this.charset);
                StreamUtil.io((Reader)reader, (Writer)this.writer, (boolean)true, (boolean)false);
                this.writer.flush();
                this.buffer.reset();
            }
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    private static class BufferedServletWriter
    extends PrintWriter {
        public BufferedServletWriter(StringWriter chars) {
            super(chars);
        }

        public void updateWriter(StringWriter chars) {
            this.out = chars;
        }
    }

    private static class BufferedServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bytes;

        public BufferedServletOutputStream(ByteArrayOutputStream bytes) {
            this.bytes = bytes;
        }

        public void updateOutputStream(ByteArrayOutputStream bytes) {
            this.bytes = bytes;
        }

        public void write(int b) throws IOException {
            this.bytes.write((int)((byte)b));
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.bytes.write(b, off, len);
        }

        public void flush() throws IOException {
            this.bytes.flush();
        }

        public void close() throws IOException {
            this.bytes.flush();
            this.bytes.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Stack<T> {
        private final LinkedList<T> list = CollectionUtil.createLinkedList();

        private Stack() {
        }

        public T peek() {
            if (this.list.isEmpty()) {
                throw new EmptyStackException();
            }
            return this.list.getLast();
        }

        public void push(T object) {
            this.list.addLast(object);
        }

        public T pop() {
            if (this.list.isEmpty()) {
                throw new EmptyStackException();
            }
            return this.list.removeLast();
        }

        public int size() {
            return this.list.size();
        }

        public boolean add(T o) {
            return this.list.add(o);
        }

        public void clear() {
            this.list.clear();
        }
    }
}

