/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinygroup.weblayer.webcontext.parser.impl.FilterRunner;

public class HTMLInputFilter {
    protected static final boolean ALWAYS_MAKE_TAGS = true;
    protected static final boolean STRIP_COMMENTS = false;
    protected static final int REGEX_FLAGS_SI = 34;
    protected final Map vAllowed;
    protected final Set vDeniedTags;
    protected final Set vSelfClosingTags;
    protected final Set vNeedClosingTags;
    protected final Set vProtocolAtts;
    protected final Set vAllowedProtocols;
    protected final Set vRemoveBlanks;
    protected final Set vAllowedEntities;
    protected static final Logger log = LoggerFactory.getLogger(HTMLInputFilter.class);

    public HTMLInputFilter() {
        this(null, null, null, null, null, null, null, null);
    }

    public HTMLInputFilter(Map allowed, String[] deniedTags, String[] selfClosingTags, String[] needClosingTags, String[] allowedProtocols, String[] protocolAtts, String[] removeBlanks, String[] allowedEntities) {
        this.vAllowed = allowed == null ? new HashMap() : allowed;
        Set a_atts = this.getOrCreateSet(this.vAllowed, "a");
        a_atts.add("href");
        a_atts.add("target");
        Set img_atts = this.getOrCreateSet(this.vAllowed, "img");
        img_atts.add("src");
        img_atts.add("width");
        img_atts.add("height");
        img_atts.add("alt");
        this.getOrCreateSet(this.vAllowed, "b");
        this.getOrCreateSet(this.vAllowed, "strong");
        this.getOrCreateSet(this.vAllowed, "i");
        this.getOrCreateSet(this.vAllowed, "em");
        this.vDeniedTags = this.mergeList(deniedTags, new String[]{"script"});
        this.vSelfClosingTags = this.mergeList(selfClosingTags, new String[]{"img"});
        this.vNeedClosingTags = this.mergeList(needClosingTags, new String[]{"a", "b", "strong", "i", "em"});
        this.vAllowedProtocols = this.mergeList(allowedProtocols, new String[]{"http", "mailto"});
        this.vProtocolAtts = this.mergeList(protocolAtts, new String[]{"src", "href"});
        this.vRemoveBlanks = this.mergeList(removeBlanks, new String[]{"a", "b", "strong", "i", "em"});
        this.vAllowedEntities = this.mergeList(allowedEntities, new String[]{"amp", "gt", "lt", "quot"});
    }

    private Set getOrCreateSet(Map map, String key) {
        HashSet set = (HashSet)map.get(key);
        if (set == null) {
            set = new HashSet();
            map.put(key, set);
        }
        return set;
    }

    private Set mergeList(String[] list, String[] defaultList) {
        HashSet<String> result = new HashSet<String>();
        if (list != null) {
            for (String element : list) {
                result.add(element);
            }
        }
        if (defaultList != null) {
            for (String element : defaultList) {
                result.add(element);
            }
        }
        return result;
    }

    public static String chr(int decimal) {
        return String.valueOf((char)decimal);
    }

    public static String htmlSpecialChars(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }

    public String filter(String input) {
        return this.filter(input, true);
    }

    public String filter(String input, boolean isHtml) {
        return new FilterRunner(this).filter(input, isHtml);
    }
}

