/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.PropertyEditorRegistrar;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.WebContext;
import org.tinygroup.weblayer.webcontext.AbstractRequestWrapper;
import org.tinygroup.weblayer.webcontext.AbstractWebContextWrapper;
import org.tinygroup.weblayer.webcontext.parser.ParserWebContext;
import org.tinygroup.weblayer.webcontext.parser.upload.ParameterParserFilter;
import org.tinygroup.weblayer.webcontext.parser.upload.UploadService;
import org.tinygroup.weblayer.webcontext.parser.valueparser.CookieParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.ParameterParser;
import org.tinygroup.weblayer.webcontext.parser.valueparser.impl.CookieParserImpl;
import org.tinygroup.weblayer.webcontext.parser.valueparser.impl.ParameterParserImpl;

public class ParserWebContextImpl
extends AbstractWebContextWrapper
implements ParserWebContext {
    private PropertyEditorRegistrar propertyEditorRegistrar;
    private boolean converterQuiet;
    private String caseFolding;
    private boolean autoUpload;
    private boolean unescapeParameters;
    private boolean useServletEngineParser;
    private boolean useBodyEncodingForURI;
    private String uriEncoding;
    private boolean trimming;
    private UploadService upload;
    private ParameterParser parameters;
    private ParameterParserFilter[] filters;
    private String htmlFieldSuffix;
    private CookieParser cookies;

    public ParserWebContextImpl(WebContext wrappedContext) {
        super(wrappedContext);
        this.setRequest((HttpServletRequest)new RequestWrapper(wrappedContext.getRequest()));
    }

    public PropertyEditorRegistrar getPropertyEditorRegistrar() {
        return this.propertyEditorRegistrar;
    }

    public void setPropertyEditorRegistrar(PropertyEditorRegistrar propertyEditorRegistrar) {
        this.propertyEditorRegistrar = propertyEditorRegistrar;
    }

    public boolean isConverterQuiet() {
        return this.converterQuiet;
    }

    public void setConverterQuiet(boolean converterQuiet) {
        this.converterQuiet = converterQuiet;
    }

    public boolean isAutoUpload() {
        return this.autoUpload;
    }

    public void setAutoUpload(boolean autoUpload) {
        this.autoUpload = autoUpload;
    }

    public String getCaseFolding() {
        return this.caseFolding;
    }

    public void setCaseFolding(String folding) {
        this.caseFolding = folding;
    }

    public boolean isUnescapeParameters() {
        return this.unescapeParameters;
    }

    public void setUnescapeParameters(boolean unescapeParameters) {
        this.unescapeParameters = unescapeParameters;
    }

    public void setUseServletEngineParser(boolean useServletEngineParser) {
        this.useServletEngineParser = useServletEngineParser;
    }

    public boolean isUseServletEngineParser() {
        return this.useServletEngineParser;
    }

    public boolean isUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
    }

    public String getURIEncoding() {
        return this.uriEncoding;
    }

    public void setURIEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public boolean isTrimming() {
        return this.trimming;
    }

    public void setTrimming(boolean trimming) {
        this.trimming = trimming;
    }

    public void setUploadService(UploadService upload) {
        this.upload = upload;
    }

    public void setParameterParserFilters(ParameterParserFilter[] filters) {
        this.filters = filters;
    }

    public String getHtmlFieldSuffix() {
        return this.htmlFieldSuffix;
    }

    public void setHtmlFieldSuffix(String htmlFieldSuffix) {
        this.htmlFieldSuffix = htmlFieldSuffix;
    }

    public ParameterParser getParameters() {
        if (this.parameters == null) {
            this.parameters = new ParameterParserImpl(this, this.upload, this.trimming, this.filters, this.htmlFieldSuffix);
        }
        return this.parameters;
    }

    public CookieParser getCookies() {
        if (this.cookies == null) {
            this.cookies = new CookieParserImpl(this);
        }
        return this.cookies;
    }

    public String convertCase(String str) {
        String folding = this.getCaseFolding();
        str = StringUtil.trimToEmpty((String)str);
        if ("lower".equals(folding)) {
            str = StringUtil.toLowerCase((String)str);
        } else if ("lower_with_underscores".equals(folding)) {
            str = StringUtil.toLowerCaseWithUnderscores((String)str);
        } else if ("upper".equals(folding)) {
            str = StringUtil.toUpperCase((String)str);
        } else if ("upper_with_underscores".equals(folding)) {
            str = StringUtil.toUpperCaseWithUnderscores((String)str);
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterEntry
    implements Map.Entry<String, String[]> {
        private final String key;

        private ParameterEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String[] getValue() {
            return ParserWebContextImpl.this.getParameters().getStrings(this.key);
        }

        @Override
        public String[] setValue(String[] value) {
            Assert.unsupportedOperation();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterEntrySet
    extends AbstractSet<Map.Entry<String, String[]>> {
        private ParameterEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, String[]>> iterator() {
            final Iterator<String> i = ParserWebContextImpl.this.getParameters().keySet().iterator();
            return new Iterator<Map.Entry<String, String[]>>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public Map.Entry<String, String[]> next() {
                    return new ParameterEntry((String)i.next());
                }

                @Override
                public void remove() {
                    Assert.unsupportedOperation();
                }
            };
        }

        @Override
        public int size() {
            return ParserWebContextImpl.this.getParameters().size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterMap
    extends AbstractMap<String, String[]> {
        private final ParameterEntrySet entrySet;

        private ParameterMap() {
            this.entrySet = new ParameterEntrySet();
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return ParserWebContextImpl.this.getParameters().containsKey((String)key);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public String[] get(Object key) {
            try {
                return ParserWebContextImpl.this.getParameters().getStrings((String)key);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public Set<Map.Entry<String, String[]>> entrySet() {
            return this.entrySet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorEnumeration<E>
    implements Enumeration<E> {
        private Iterator<E> iterator;

        public IteratorEnumeration(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RequestWrapper
    extends AbstractRequestWrapper {
        private final ParameterMap parameterMap;

        public RequestWrapper(HttpServletRequest request) {
            super(ParserWebContextImpl.this, request);
            this.parameterMap = new ParameterMap();
        }

        public String getParameter(String key) {
            String value = ParserWebContextImpl.this.getParameters().getString(key);
            if (value == null) {
                value = super.getParameter(key);
            }
            return value;
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            Set<String> keySet = ParserWebContextImpl.this.getParameters().keySet();
            if (keySet.isEmpty()) {
                return super.getParameterNames();
            }
            return new IteratorEnumeration<String>(keySet.iterator());
        }

        public String[] getParameterValues(String key) {
            String[] values = ParserWebContextImpl.this.getParameters().getStrings(key);
            if (values == null || values.length == 0) {
                values = super.getParameterValues(key);
            }
            return values;
        }
    }
}

