/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.parser.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.RequestContext;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.weblayer.webcontext.parser.fileupload.TinyFileItem;
import org.tinygroup.weblayer.webcontext.parser.impl.AbstractFileItem;
import org.tinygroup.weblayer.webcontext.parser.impl.DiskFileItemFactory;
import org.tinygroup.weblayer.webcontext.parser.impl.ServletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletFileUpload
extends org.apache.commons.fileupload.servlet.ServletFileUpload {
    private String[] fileNameKey;

    public ServletFileUpload() {
    }

    public ServletFileUpload(FileItemFactory fileItemFactory) {
        super(fileItemFactory);
    }

    public String[] getFileNameKey() {
        if (ArrayUtil.isEmptyArray((Object)this.fileNameKey)) {
            this.fileNameKey = new String[]{"filename"};
        }
        return this.fileNameKey;
    }

    public void setFileNameKey(String[] fileNameKey) {
        this.fileNameKey = fileNameKey;
    }

    public List<?> parseRequest(HttpServletRequest request) throws FileUploadException {
        return this.parseRequest((RequestContext)new ServletRequestContext(request));
    }

    public List<?> parseRequest(RequestContext ctx) throws FileUploadException {
        FileItemFactory itemFactory = this.getFileItemFactory();
        if (itemFactory instanceof DiskFileItemFactory) {
            DiskFileItemFactory factory = (DiskFileItemFactory)itemFactory;
            factory.setRequest(((ServletRequestContext)ctx).getRequest());
        }
        List items = super.parseRequest(ctx);
        String charset = ctx.getCharacterEncoding();
        for (FileItem fileItem : items) {
            if (fileItem instanceof AbstractFileItem) {
                ((AbstractFileItem)fileItem).setCharset(charset);
            }
            if (!(fileItem instanceof TinyFileItem)) continue;
            TinyFileItem tinyFileItem = (TinyFileItem)fileItem;
            tinyFileItem.setCharset(charset);
            tinyFileItem.storage();
        }
        return items;
    }

    protected String getFileName(Map headers) {
        return this.getFileName(this.getHeader(headers, "Content-disposition"));
    }

    protected String getFileName(FileItemHeaders headers) {
        return this.getFileName(headers.getHeader("Content-disposition"));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase()).startsWith("form-data") || cdl.startsWith("attachment"))) {
            String key;
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(pContentDisposition, ';');
            String[] arr$ = this.getFileNameKey();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (fileName = StringUtil.trimToNull((String)((String)params.get(key = arr$[i$])))) == null; ++i$) {
            }
        }
        return fileName;
    }

    public FileItemIterator getItemIterator(HttpServletRequest request) throws FileUploadException, IOException {
        return super.getItemIterator((RequestContext)new ServletRequestContext(request));
    }
}

