/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.BasicConstant;
import org.tinygroup.commons.tools.MatchResultSubstitution;
import org.tinygroup.commons.tools.StringEscapeUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ToStringBuilder;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.weblayer.webcontext.rewrite.Flags;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteUtil;

public class RewriteCondition
implements InitializingBean {
    private static final String SPLIT_CHAR = ",";
    private static final Logger logger = LoggerFactory.getLogger(RewriteCondition.class);
    private String testString;
    private String patternString;
    private Pattern pattern;
    private boolean negative;
    private String flags;
    private ConditionFlags conditionFlags;

    public void setTest(String testString) {
        this.testString = StringUtil.trimToNull((String)testString);
    }

    public void setPattern(String patternString) throws PatternSyntaxException {
        this.patternString = StringUtil.trimToNull((String)patternString);
    }

    public void setFlags(String flags) {
        this.flags = flags;
        String[] flagArray = null;
        flagArray = StringUtil.isEmpty((String)flags) ? BasicConstant.EMPTY_STRING_ARRAY : flags.split(SPLIT_CHAR);
        this.conditionFlags = new ConditionFlags(flagArray);
    }

    public String getFlags() {
        return this.flags;
    }

    public ConditionFlags getConditionFlags() {
        return this.conditionFlags;
    }

    public void afterPropertiesSet() throws Exception {
        String realPattern;
        Assert.assertNotNull((Object)this.testString, (String)"missing test attribute for condition", (Object[])new Object[0]);
        if (this.patternString == null || "!".equals(this.patternString)) {
            throw new PatternSyntaxException("empty pattern", this.patternString, -1);
        }
        if (this.patternString.startsWith("!")) {
            this.negative = true;
            realPattern = this.patternString.substring(1);
        } else {
            realPattern = this.patternString;
        }
        this.pattern = Pattern.compile(realPattern);
        if (this.conditionFlags == null) {
            this.conditionFlags = new ConditionFlags();
        }
    }

    public MatchResult match(MatchResult ruleMatchResult, MatchResult conditionMatchResult, HttpServletRequest request) {
        logger.logMessage(LogLevel.TRACE, "Testing condition: testString=\"{}\", pattern=\"{}\"", new Object[]{StringEscapeUtil.escapeJava((String)this.testString), StringEscapeUtil.escapeJava((String)this.patternString)});
        String subsTestString = RewriteUtil.getSubstitutedTestString(this.testString, ruleMatchResult, conditionMatchResult, request);
        logger.logMessage(LogLevel.TRACE, "Expanded testString: original=\"{}\", expanded=\"{}\"", new Object[]{StringEscapeUtil.escapeJava((String)this.testString), StringEscapeUtil.escapeJava((String)subsTestString)});
        Matcher matcher = this.pattern.matcher(subsTestString);
        boolean matched = matcher.find();
        if (!this.negative && matched) {
            logger.logMessage(LogLevel.DEBUG, "Testing \"{}\" with condition pattern: \"{}\", MATCHED", new Object[]{StringEscapeUtil.escapeJava((String)subsTestString), StringEscapeUtil.escapeJava((String)this.patternString)});
            return matcher.toMatchResult();
        }
        if (this.negative && !matched) {
            logger.logMessage(LogLevel.DEBUG, "Testing \"{}\" with condition pattern: \"{}\", MATCHED", new Object[]{StringEscapeUtil.escapeJava((String)subsTestString), StringEscapeUtil.escapeJava((String)this.patternString)});
            return MatchResultSubstitution.EMPTY_MATCH_RESULT;
        }
        logger.logMessage(LogLevel.TRACE, "Testing \"{}\" with condition pattern: \"{}\", MISMATCHED", new Object[]{StringEscapeUtil.escapeJava((String)subsTestString), StringEscapeUtil.escapeJava((String)this.patternString)});
        return null;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("test", (Object)this.testString);
        mb.append("pattern", (Object)this.patternString);
        if (!this.conditionFlags.isEmpty()) {
            mb.append("flags", (Object)this.conditionFlags);
        }
        return new ToStringBuilder().append((Object)"Condition").append((Object)mb).toString();
    }

    public static class ConditionFlags
    extends Flags {
        public ConditionFlags() {
        }

        public ConditionFlags(String ... flags) {
            super(flags);
        }

        public boolean hasOR() {
            return this.hasFlags("OR", "ornext");
        }
    }
}

