/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.weblayer.webcontext.rewrite;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.config.impl.AbstractConfiguration;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteCondition;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteRule;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitution;
import org.tinygroup.weblayer.webcontext.rewrite.RewriteSubstitutionHandler;
import org.tinygroup.xmlparser.node.XmlNode;

public class RewriteConfiguration
extends AbstractConfiguration {
    private static final String CONDITION = "condition";
    private static final String PATTERN = "pattern";
    private static final String RULE = "rule";
    private static final String REWRITE_CONFIG = "/application/rewrite";
    private RewriteRule[] rules;

    public String getApplicationNodePath() {
        return REWRITE_CONFIG;
    }

    public String getComponentConfigPath() {
        return null;
    }

    public void config(XmlNode applicationConfig, XmlNode componentConfig) {
        NameFilter nameFilter;
        List ruleNodes;
        super.config(applicationConfig, componentConfig);
        if (applicationConfig != null && !CollectionUtil.isEmpty((Collection)(ruleNodes = (nameFilter = new NameFilter((Node)applicationConfig)).findNodeList(RULE)))) {
            this.rules = new RewriteRule[ruleNodes.size()];
            for (int i = 0; i < ruleNodes.size(); ++i) {
                XmlNode ruleNode = (XmlNode)ruleNodes.get(i);
                RewriteRule rule = new RewriteRule();
                rule.setPattern(ruleNode.getAttribute(PATTERN));
                this.resolverCondition(ruleNode, rule);
                this.resolverSubstitution(ruleNode, rule);
                this.resolverHandlers(ruleNode, rule);
                this.rules[i] = rule;
                try {
                    rule.afterPropertiesSet();
                    continue;
                }
                catch (Exception e) {
                    logger.errorMessage("initializingBean error", (Throwable)e);
                    throw new RuntimeException("initializingBean error", e);
                }
            }
        }
    }

    public RewriteRule[] getRules() {
        return this.rules;
    }

    private void resolverHandlers(XmlNode ruleNode, RewriteRule rule) {
        NameFilter nameFilter = new NameFilter((Node)ruleNode);
        List subNodes = nameFilter.findNodeList("rewrite-handler");
        if (!CollectionUtil.isEmpty((Collection)subNodes)) {
            Object[] handlers = (RewriteSubstitutionHandler[])Array.newInstance(RewriteSubstitutionHandler.class, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                XmlNode subNode = (XmlNode)subNodes.get(i);
                String beanName = subNode.getAttribute("bean-name");
                RewriteSubstitutionHandler handler = (RewriteSubstitutionHandler)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean(beanName);
                handlers[i] = handler;
            }
            rule.setHandlers(handlers);
        }
    }

    private void resolverCondition(XmlNode ruleNode, RewriteRule rule) {
        NameFilter nameFilter = new NameFilter((Node)ruleNode);
        List subNodes = nameFilter.findNodeList(CONDITION);
        if (!CollectionUtil.isEmpty((Collection)subNodes)) {
            RewriteCondition[] conditions = (RewriteCondition[])Array.newInstance(RewriteCondition.class, subNodes.size());
            for (int i = 0; i < subNodes.size(); ++i) {
                XmlNode subNode = (XmlNode)subNodes.get(i);
                RewriteCondition condition = new RewriteCondition();
                condition.setTest(subNode.getAttribute("test"));
                condition.setFlags(subNode.getAttribute("flags"));
                condition.setPattern(subNode.getAttribute(PATTERN));
                conditions[i] = condition;
            }
            rule.setConditions(conditions);
        }
    }

    private void resolverSubstitution(XmlNode ruleNode, RewriteRule rule) {
        NameFilter nameFilter = new NameFilter((Node)ruleNode);
        XmlNode subNode = (XmlNode)nameFilter.findNode("substitution");
        if (subNode != null) {
            RewriteSubstitution substitution = new RewriteSubstitution();
            substitution.setFlags(subNode.getAttribute("flags"));
            substitution.setUri(subNode.getAttribute("uri"));
            NameFilter paramFilter = new NameFilter((Node)subNode);
            List paramNodes = paramFilter.findNodeList("parameter");
            if (!CollectionUtil.isEmpty((Collection)paramNodes)) {
                RewriteSubstitution.Parameter[] parameters = (RewriteSubstitution.Parameter[])Array.newInstance(RewriteSubstitution.Parameter.class, paramNodes.size());
                for (int i = 0; i < parameters.length; ++i) {
                    XmlNode paramNode = (XmlNode)paramNodes.get(i);
                    RewriteSubstitution.Parameter parameter = new RewriteSubstitution.Parameter();
                    parameter.setKey(paramNode.getAttribute("key"));
                    parameter.setValue(paramNode.getAttribute("value"));
                    parameters[i] = parameter;
                }
                substitution.setParameters(parameters);
            }
            rule.setSubstitution(substitution);
        }
    }
}

